/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.builder.model.NativeAndroidProject;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.android.AndroidContentEntriesSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.common.ContentEntriesSetup;
import com.android.tools.idea.gradle.util.FilePaths;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentRootsModuleSetupStep
extends AndroidModuleSetupStep {
    @NotNull
    private final AndroidContentEntriesSetup.Factory myContentEntriesSetupFactory;

    public ContentRootsModuleSetupStep() {
        this(new AndroidContentEntriesSetup.Factory());
    }

    @VisibleForTesting
    ContentRootsModuleSetupStep(@NotNull AndroidContentEntriesSetup.Factory contentEntriesSetupFactory) {
        if (contentEntriesSetupFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntriesSetupFactory", "com/android/tools/idea/gradle/project/sync/setup/module/android/ContentRootsModuleSetupStep", "<init>"));
        }
        this.myContentEntriesSetupFactory = contentEntriesSetupFactory;
    }

    @Override
    protected void doSetUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull AndroidModuleModel androidModel, @Nullable SyncAction.ModuleModels gradleModels, @Nullable ProgressIndicator indicator) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/android/ContentRootsModuleSetupStep", "doSetUpModule"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/android/ContentRootsModuleSetupStep", "doSetUpModule"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/project/sync/setup/module/android/ContentRootsModuleSetupStep", "doSetUpModule"));
        }
        ModifiableRootModel moduleModel = ideModelsProvider.getModifiableRootModel(module);
        boolean hasNativeModel = ContentRootsModuleSetupStep.hasNativeModel(module, ideModelsProvider, gradleModels);
        AndroidContentEntriesSetup setup = this.myContentEntriesSetupFactory.create(androidModel, moduleModel, hasNativeModel);
        List<ContentEntry> contentEntries = ContentRootsModuleSetupStep.findContentEntries(moduleModel, androidModel, hasNativeModel);
        setup.execute(contentEntries);
    }

    @NotNull
    private static List<ContentEntry> findContentEntries(@NotNull ModifiableRootModel moduleModel, @NotNull AndroidModuleModel androidModel, boolean hasNativeModel) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/project/sync/setup/module/android/ContentRootsModuleSetupStep", "findContentEntries"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/project/sync/setup/module/android/ContentRootsModuleSetupStep", "findContentEntries"));
        }
        if (!hasNativeModel) {
            ContentEntriesSetup.removeExistingContentEntries(moduleModel);
        }
        ArrayList<ContentEntry> contentEntries = new ArrayList<ContentEntry>();
        ContentEntry contentEntry = moduleModel.addContentEntry(androidModel.getRootDir());
        contentEntries.add(contentEntry);
        File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
        if (!FileUtil.isAncestor((File)androidModel.getRootDirPath(), (File)buildFolderPath, (boolean)false)) {
            contentEntries.add(moduleModel.addContentEntry(FilePaths.pathToIdeaUrl(buildFolderPath)));
        }
        ArrayList<ContentEntry> arrayList = contentEntries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/android/ContentRootsModuleSetupStep", "findContentEntries"));
        }
        return arrayList;
    }

    private static boolean hasNativeModel(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @Nullable SyncAction.ModuleModels gradleModels) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/android/ContentRootsModuleSetupStep", "hasNativeModel"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/android/ContentRootsModuleSetupStep", "hasNativeModel"));
        }
        if (gradleModels != null) {
            return gradleModels.findModel(NativeAndroidProject.class) != null;
        }
        NdkFacet facet = (NdkFacet)((Object)Facets.findFacet(module, ideModelsProvider, NdkFacet.getFacetType().getId()));
        return facet != null && facet.getNdkModuleModel() != null;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Source folder(s) setup" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/android/ContentRootsModuleSetupStep", "getDescription"));
        }
        return "Source folder(s) setup";
    }

    @Override
    public boolean invokeOnBuildVariantChange() {
        return true;
    }
}

