/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LibraryDependency
extends Dependency {
    @NotNull
    private final Map<PathType, Collection<File>> myPathsByType;
    @NotNull
    private final File myArtifactPath;
    private String myName;

    @VisibleForTesting
    public LibraryDependency(@NotNull File artifactPath, @NotNull DependencyScope scope) {
        if (artifactPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactPath", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency", "<init>"));
        }
        this(artifactPath, FileUtil.getNameWithoutExtension((File)artifactPath), scope);
        this.addPath(PathType.BINARY, artifactPath);
    }

    LibraryDependency(@NotNull File artifactPath, @NotNull String name, @NotNull DependencyScope scope) {
        if (artifactPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactPath", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency", "<init>"));
        }
        super(scope);
        this.myPathsByType = new EnumMap<PathType, Collection<File>>(PathType.class);
        this.myArtifactPath = artifactPath;
        this.setName(name);
    }

    @VisibleForTesting
    public void addPath(@NotNull PathType type, @NotNull File path) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency", "addPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency", "addPath"));
        }
        Collection<File> paths = this.myPathsByType.get((Object)type);
        if (paths == null) {
            paths = new HashSet<File>();
            this.myPathsByType.put(type, paths);
        }
        paths.add(path);
    }

    @NotNull
    public File[] getPaths(@NotNull PathType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency", "getPaths"));
        }
        Collection<File> paths = this.myPathsByType.get((Object)type);
        File[] fileArray = paths == null || paths.isEmpty() ? ArrayUtilRt.EMPTY_FILE_ARRAY : paths.toArray(new File[paths.size()]);
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency", "getPaths"));
        }
        return fileArray;
    }

    @NotNull
    public File getArtifactPath() {
        File file = this.myArtifactPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency", "getArtifactPath"));
        }
        return file;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency", "getName"));
        }
        return string;
    }

    void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency", "setName"));
        }
        this.myName = name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name='" + this.myName + '\'' + ", scope=" + this.getScope() + ", pathsByType=" + this.myPathsByType + "]";
    }

    public static enum PathType {
        BINARY,
        DOCUMENTATION;

    }
}

