/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgradeStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class PluginVersionUpgrade {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PluginVersionUpgradeStep[] myUpgradeSteps;

    public PluginVersionUpgrade(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/PluginVersionUpgrade", "<init>"));
        }
        this(project, PluginVersionUpgradeStep.getExtensions());
    }

    @VisibleForTesting
    PluginVersionUpgrade(@NotNull Project project, PluginVersionUpgradeStep ... upgradeSteps) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/PluginVersionUpgrade", "<init>"));
        }
        if (upgradeSteps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upgradeSteps", "com/android/tools/idea/gradle/project/sync/setup/post/PluginVersionUpgrade", "<init>"));
        }
        this.myProject = project;
        this.myUpgradeSteps = upgradeSteps;
    }

    public boolean checkAndPerformUpgrade() {
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(this.myProject);
        if (pluginInfo == null) {
            PluginVersionUpgrade.getLog().warn("Unable to obtain application's Android Project");
            return false;
        }
        PluginVersionUpgrade.log(pluginInfo);
        for (PluginVersionUpgradeStep upgradeStep : this.myUpgradeSteps) {
            if (!upgradeStep.checkAndPerformUpgrade(this.myProject, pluginInfo)) continue;
            return true;
        }
        return false;
    }

    private static void log(@NotNull AndroidPluginInfo pluginInfo) {
        if (pluginInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginInfo", "com/android/tools/idea/gradle/project/sync/setup/post/PluginVersionUpgrade", "log"));
        }
        GradleVersion current = pluginInfo.getPluginVersion();
        String recommended = pluginInfo.getPluginGeneration().getLatestKnownVersion();
        String message = String.format("Gradle model version: %1$s, recommended version for IDE: %2$s", current, recommended);
        PluginVersionUpgrade.getLog().info(message);
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(PluginVersionUpgrade.class);
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/PluginVersionUpgrade", "getLog"));
        }
        return logger;
    }
}

