/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectCleanup {
    @NotNull
    private final ProjectCleanupStep[] myCleanupSteps;

    public ProjectCleanup() {
        this(ProjectCleanupStep.getExtensions());
    }

    @VisibleForTesting
    ProjectCleanup(@NotNull ProjectCleanupStep[] cleanupSteps) {
        if (cleanupSteps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cleanupSteps", "com/android/tools/idea/gradle/project/sync/setup/post/ProjectCleanup", "<init>"));
        }
        this.myCleanupSteps = cleanupSteps;
    }

    public void cleanUpProject(@NotNull Project project, @NotNull IdeModifiableModelsProvider ideModelsProvider, @Nullable ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/ProjectCleanup", "cleanUpProject"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/post/ProjectCleanup", "cleanUpProject"));
        }
        for (ProjectCleanupStep cleanupStep : this.myCleanupSteps) {
            cleanupStep.cleanUpProject(project, ideModelsProvider, indicator);
        }
    }
}

