/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.android;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidProjectValidationStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutRenderingIssueValidationStrategy
extends AndroidProjectValidationStrategy {
    @Nullable
    private GradleVersion myModelVersion;

    LayoutRenderingIssueValidationStrategy(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/validation/android/LayoutRenderingIssueValidationStrategy", "<init>"));
        }
        super(project);
    }

    @Override
    void validate(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/validation/android/LayoutRenderingIssueValidationStrategy", "validate"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/project/sync/validation/android/LayoutRenderingIssueValidationStrategy", "validate"));
        }
        if (androidModel.getFeatures().isLayoutRenderingIssuePresent()) {
            this.myModelVersion = androidModel.getModelVersion();
        }
    }

    @Override
    void fixAndReportFoundIssues() {
        if (this.myModelVersion != null) {
            String text = String.format("Using an obsolete version of the Gradle plugin (%1$s);", this.myModelVersion);
            text = text + " this can lead to layouts not rendering correctly.";
            SyncMessage message = new SyncMessage("Gradle Sync Issues", MessageType.WARNING, text);
            message.add(Arrays.asList(new FixAndroidGradlePluginVersionHyperlink(), new OpenUrlHyperlink("https://code.google.com/p/android/issues/detail?id=170841", "More Info...")));
            SyncMessages.getInstance(this.getProject()).report(message);
        }
    }

    @VisibleForTesting
    @Nullable
    GradleVersion getModelVersion() {
        return this.myModelVersion;
    }

    @VisibleForTesting
    void setModelVersion(@Nullable GradleVersion modelVersion) {
        this.myModelVersion = modelVersion;
    }
}

