/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.common;

import com.android.tools.idea.gradle.project.sync.validation.common.CommonProjectValidationStrategy;
import com.android.tools.idea.gradle.project.sync.validation.common.UniquePathModuleValidatorStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public abstract class CommonModuleValidator {
    public abstract void validate(@NotNull Module var1);

    public abstract void fixAndReportFoundIssues();

    @VisibleForTesting
    static class CommonModuleValidatorImpl
    extends CommonModuleValidator {
        @NotNull
        private final CommonProjectValidationStrategy[] myStrategies;

        CommonModuleValidatorImpl(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/validation/common/CommonModuleValidator$CommonModuleValidatorImpl", "<init>"));
            }
            this(new UniquePathModuleValidatorStrategy(project));
        }

        @VisibleForTesting
        CommonModuleValidatorImpl(CommonProjectValidationStrategy ... strategies) {
            if (strategies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategies", "com/android/tools/idea/gradle/project/sync/validation/common/CommonModuleValidator$CommonModuleValidatorImpl", "<init>"));
            }
            this.myStrategies = strategies;
        }

        @Override
        public void validate(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/validation/common/CommonModuleValidator$CommonModuleValidatorImpl", "validate"));
            }
            for (CommonProjectValidationStrategy strategy : this.myStrategies) {
                strategy.validate(module);
            }
        }

        @Override
        public void fixAndReportFoundIssues() {
            for (CommonProjectValidationStrategy strategy : this.myStrategies) {
                strategy.fixAndReportFoundIssues();
            }
        }

        @VisibleForTesting
        @NotNull
        CommonProjectValidationStrategy[] getStrategies() {
            if (this.myStrategies == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/validation/common/CommonModuleValidator$CommonModuleValidatorImpl", "getStrategies"));
            }
            return this.myStrategies;
        }
    }

    public static class Factory {
        @NotNull
        public CommonModuleValidator create(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/validation/common/CommonModuleValidator$Factory", "create"));
            }
            CommonModuleValidatorImpl commonModuleValidatorImpl = new CommonModuleValidatorImpl(project);
            if (commonModuleValidatorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/validation/common/CommonModuleValidator$Factory", "create"));
            }
            return commonModuleValidatorImpl;
        }
    }
}

