/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.util.BuildMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.Semaphore;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GradleTaskRunner {
    public static final String USE_SPLIT_APK = "USE_SPLIT_APK";

    public boolean run(@NotNull List<String> var1, @Nullable BuildMode var2, @NotNull List<String> var3) throws InvocationTargetException, InterruptedException;

    public static GradleTaskRunner newRunner(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/GradleTaskRunner", "newRunner"));
        }
        return new GradleTaskRunner(){

            @Override
            public boolean run(@NotNull List<String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments) throws InvocationTargetException, InterruptedException {
                if (tasks == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/run/GradleTaskRunner$1", "run"));
                }
                if (commandLineArguments == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArguments", "com/android/tools/idea/gradle/run/GradleTaskRunner$1", "run"));
                }
                assert (!ApplicationManager.getApplication().isDispatchThread());
                final GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(project);
                final AtomicBoolean success = new AtomicBoolean();
                final Semaphore done = new Semaphore();
                done.down();
                GradleBuildInvoker.AfterGradleInvocationTask afterTask = new GradleBuildInvoker.AfterGradleInvocationTask(){

                    @Override
                    public void execute(@NotNull GradleInvocationResult result) {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/run/GradleTaskRunner$1$1", "execute"));
                        }
                        success.set(result.isBuildSuccessful());
                        gradleBuildInvoker.remove(this);
                        done.up();
                    }
                };
                TransactionGuard.submitTransaction((Disposable)project, () -> {
                    if (tasks == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/run/GradleTaskRunner$1", "lambda$run$0"));
                    }
                    if (commandLineArguments == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArguments", "com/android/tools/idea/gradle/run/GradleTaskRunner$1", "lambda$run$0"));
                    }
                    gradleBuildInvoker.add(afterTask);
                    gradleBuildInvoker.executeTasks(tasks, buildMode, commandLineArguments);
                });
                done.waitFor();
                return success.get();
            }
        };
    }
}

