/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.quickfix;

import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.base.Joiner;
import org.jetbrains.annotations.NotNull;

public class PsLibraryDependencyVersionQuickFixPath
extends PsPath {
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myDependency;
    @NotNull
    private final String myVersion;
    @NotNull
    private String myHrefText;

    public PsLibraryDependencyVersionQuickFixPath(@NotNull PsLibraryDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath", "<init>"));
        }
        this.myHrefText = "[Fix]";
        this.myModuleName = dependency.getParent().getName();
        this.myDependency = PsLibraryDependencyVersionQuickFixPath.getCompactNotation(dependency);
        String version = dependency.getResolvedSpec().version;
        assert (version != null);
        this.myVersion = version;
    }

    public PsLibraryDependencyVersionQuickFixPath(@NotNull PsLibraryDependency dependency, @NotNull String version) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath", "<init>"));
        }
        this.myHrefText = "[Fix]";
        this.myModuleName = dependency.getParent().getName();
        this.myDependency = PsLibraryDependencyVersionQuickFixPath.getCompactNotation(dependency);
        this.myVersion = version;
    }

    @NotNull
    private static String getCompactNotation(@NotNull PsLibraryDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath", "getCompactNotation"));
        }
        PsArtifactDependencySpec spec = dependency.getDeclaredSpec();
        if (spec == null) {
            spec = dependency.getResolvedSpec();
        }
        String string = spec.compactNotation();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath", "getCompactNotation"));
        }
        return string;
    }

    @Override
    @NotNull
    public String toText(@NotNull PsPath.TexType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath", "toText"));
        }
        if (type == PsPath.TexType.HTML) {
            String string = this.getHtmlText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath", "toText"));
            }
            return string;
        }
        String string = this.myDependency;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath", "toText"));
        }
        return string;
    }

    public void setHrefText(@NotNull String hrefText) {
        if (hrefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hrefText", "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath", "setHrefText"));
        }
        this.myHrefText = hrefText;
    }

    @NotNull
    private String getHtmlText() {
        String path = Joiner.on((char)'/').join((Object)"setLibraryDependency", (Object)this.myModuleName, new Object[]{this.myDependency, this.myVersion});
        String href = "psdFix://" + path;
        String string = String.format("<a href='%1$s'>%2$s</a>", href, this.myHrefText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/quickfix/PsLibraryDependencyVersionQuickFixPath", "getHtmlText"));
        }
        return string;
    }
}

