/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.collect.Lists;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class AndroidStudioPreferences {
    public static void cleanUpPreferences(@NotNull ExtensionPoint<ConfigurableEP<Configurable>> preferences, @NotNull List<String> bundlesToRemove) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/android/tools/idea/gradle/util/AndroidStudioPreferences", "cleanUpPreferences"));
        }
        if (bundlesToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundlesToRemove", "com/android/tools/idea/gradle/util/AndroidStudioPreferences", "cleanUpPreferences"));
        }
        ArrayList nonStudioExtensions = Lists.newArrayList();
        ConfigurableEP[] extensions = (ConfigurableEP[])preferences.getExtensions();
        for (ConfigurableEP extension : extensions) {
            if (!bundlesToRemove.contains(extension.instanceClass)) continue;
            nonStudioExtensions.add(extension);
        }
        for (ConfigurableEP toRemove : nonStudioExtensions) {
            preferences.unregisterExtension((Object)toRemove);
        }
    }
}

