/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.util.PropertiesFiles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalProperties {
    @NotNull
    private final File myPropertiesFilePath;
    @NotNull
    private final File myProjectFolderPath;
    @NotNull
    private final Properties myProperties;
    @Nullable
    private File myNewAndroidSdkPath;
    private boolean myAndroidSdkPathModified;
    @Nullable
    private File myNewAndroidNdkPath;
    private boolean myAndroidNdkPathModified;

    public LocalProperties(@NotNull Project project) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/LocalProperties", "<init>"));
        }
        this(Projects.getBaseDirPath(project));
    }

    public LocalProperties(@NotNull File projectFolderPath) throws IOException {
        if (projectFolderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFolderPath", "com/android/tools/idea/gradle/util/LocalProperties", "<init>"));
        }
        this.myProjectFolderPath = projectFolderPath;
        this.myPropertiesFilePath = new File(projectFolderPath, "local.properties");
        this.myProperties = PropertiesFiles.getProperties(this.myPropertiesFilePath);
    }

    @Nullable
    public File getAndroidSdkPath() {
        if (this.myAndroidSdkPathModified) {
            return this.myNewAndroidSdkPath;
        }
        return this.getAndroidSdkPathFromFile();
    }

    @Nullable
    public File getAndroidNdkPath() {
        if (this.myAndroidNdkPathModified) {
            return this.myNewAndroidNdkPath;
        }
        return this.getAndroidNdkPathFromFile();
    }

    public void setAndroidSdkPath(@NotNull Sdk androidSdk) {
        if (androidSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdk", "com/android/tools/idea/gradle/util/LocalProperties", "setAndroidSdkPath"));
        }
        String androidSdkPath = androidSdk.getHomePath();
        assert (androidSdkPath != null);
        this.setAndroidSdkPath(androidSdkPath);
    }

    public void setAndroidSdkPath(@NotNull String androidSdkPath) {
        if (androidSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdkPath", "com/android/tools/idea/gradle/util/LocalProperties", "setAndroidSdkPath"));
        }
        this.setAndroidSdkPath(new File(FileUtil.toSystemDependentName((String)androidSdkPath)));
    }

    public void setAndroidSdkPath(@NotNull File androidSdkPath) {
        if (androidSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdkPath", "com/android/tools/idea/gradle/util/LocalProperties", "setAndroidSdkPath"));
        }
        this.myNewAndroidSdkPath = androidSdkPath;
        this.myAndroidSdkPathModified = true;
    }

    public void setAndroidNdkPath(@NotNull String androidNdkPath) {
        if (androidNdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidNdkPath", "com/android/tools/idea/gradle/util/LocalProperties", "setAndroidNdkPath"));
        }
        this.setAndroidNdkPath(new File(FileUtil.toSystemDependentName((String)androidNdkPath)));
    }

    public void setAndroidNdkPath(@Nullable File androidNdkPath) {
        this.myNewAndroidNdkPath = androidNdkPath;
        this.myAndroidNdkPathModified = true;
    }

    public boolean hasAndroidDirProperty() {
        String property = this.getProperty("android.dir");
        return !Strings.isNullOrEmpty((String)property);
    }

    @Nullable
    public String getProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/gradle/util/LocalProperties", "getProperty"));
        }
        return this.myProperties.getProperty(key);
    }

    public void save() throws IOException {
        this.setPathIfApplicable(this.myAndroidSdkPathModified, "sdk.dir", this.getAndroidSdkPathFromFile(), this.myNewAndroidSdkPath);
        this.setPathIfApplicable(this.myAndroidNdkPathModified, "ndk.dir", this.getAndroidNdkPathFromFile(), this.myNewAndroidNdkPath);
        if (this.myAndroidSdkPathModified || this.myAndroidNdkPathModified) {
            PropertiesFiles.savePropertiesToFile(this.myProperties, this.myPropertiesFilePath, LocalProperties.getHeaderComment());
        }
        this.myNewAndroidNdkPath = null;
        this.myNewAndroidSdkPath = null;
        this.myAndroidNdkPathModified = false;
        this.myAndroidSdkPathModified = false;
    }

    private void setPathIfApplicable(boolean pathModified, @NotNull String propertyName, @Nullable File currentPath, @Nullable File newPath) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/android/tools/idea/gradle/util/LocalProperties", "setPathIfApplicable"));
        }
        if (pathModified && !FileUtil.filesEqual((File)currentPath, (File)newPath)) {
            String path;
            String string = path = newPath != null ? newPath.getPath() : null;
            if (StringUtil.isNotEmpty((String)path)) {
                this.myProperties.setProperty(propertyName, path);
            } else {
                this.myProperties.remove(propertyName);
            }
        }
    }

    @Nullable
    private File getAndroidSdkPathFromFile() {
        return this.getPath("sdk.dir");
    }

    @Nullable
    private File getAndroidNdkPathFromFile() {
        return this.getPath("ndk.dir");
    }

    @Nullable
    private File getPath(String property) {
        String path = this.getProperty(property);
        if (StringUtil.isNotEmpty((String)path)) {
            String canonicalPath;
            File file;
            if (!FileUtil.isAbsolute((String)path) && !(file = new File(canonicalPath = FileUtil.toCanonicalPath((String)new File(this.myProjectFolderPath, FileUtil.toSystemDependentName((String)path)).getPath()))).isDirectory()) {
                return new File(path);
            }
            return new File(FileUtil.toSystemDependentName((String)path));
        }
        return null;
    }

    @NotNull
    private static String getHeaderComment() {
        Object[] lines = new String[]{"# This file is automatically generated by Android Studio.", "# Do not modify this file -- YOUR CHANGES WILL BE ERASED!", "#", "# This file must *NOT* be checked into Version Control Systems,", "# as it contains information specific to your local configuration.", "", "# Location of the SDK. This is only used by Gradle.", "# For customization when using a Version Control System, please read the", "# header note."};
        String string = Joiner.on((String)SystemProperties.getLineSeparator()).join(lines);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/LocalProperties", "getHeaderComment"));
        }
        return string;
    }

    @NotNull
    public File getPropertiesFilePath() {
        File file = this.myPropertiesFilePath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/LocalProperties", "getPropertiesFilePath"));
        }
        return file;
    }

    @VisibleForTesting
    @NotNull
    Properties properties() {
        Properties properties = this.myProperties;
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/LocalProperties", "properties"));
        }
        return properties;
    }
}

