/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.resources.ResourceUrl;
import com.android.tools.idea.lint.GenerateBackupDescriptorFix;
import com.android.tools.idea.lint.SetAndGenerateBackupDescriptor;
import com.android.tools.lint.checks.ManifestDetector;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintAllowBackupInspection
extends AndroidLintInspectionBase {
    public AndroidLintAllowBackupInspection() {
        super(AndroidBundle.message("android.lint.inspections.allow.backup", new Object[0]), ManifestDetector.ALLOW_BACKUP);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        ResourceUrl url;
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintAllowBackupInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintAllowBackupInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintAllowBackupInspection", "getQuickFixes"));
        }
        if ("Missing `<full-backup-content>` resource".equals(message) && (url = ResourceUrl.parse((String)startElement.getText())) != null) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new GenerateBackupDescriptorFix(url)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintAllowBackupInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set backup attribute", "allowBackup", null), new SetAttributeQuickFix("Set fullBackupContent attribute", "fullBackupContent", null){

            @Override
            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                if (startElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintAllowBackupInspection$1", "isApplicable"));
                }
                if (endElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintAllowBackupInspection$1", "isApplicable"));
                }
                if (contextType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/android/tools/idea/lint/AndroidLintAllowBackupInspection$1", "isApplicable"));
                }
                return SetAndGenerateBackupDescriptor.isAllowBackupEnabled(startElement) && super.isApplicable(startElement, endElement, contextType);
            }
        }, new SetAndGenerateBackupDescriptor()};
        if (androidLintQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintAllowBackupInspection", "getQuickFixes"));
        }
        return androidLintQuickFixArray;
    }
}

