/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.webp.ConvertToWebpAction;
import com.android.tools.lint.checks.IconDetector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintConvertToWebpInspection
extends AndroidLintInspectionBase {
    public AndroidLintConvertToWebpInspection() {
        super(AndroidBundle.message("android.lint.inspections.convert.to.webp", new Object[0]), IconDetector.WEBP_ELIGIBLE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintConvertToWebpInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintConvertToWebpInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintConvertToWebpInspection", "getQuickFixes"));
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new DefaultLintQuickFix("Convert images to WebP..."){

            @Override
            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                if (startElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintConvertToWebpInspection$1", "isApplicable"));
                }
                if (endElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintConvertToWebpInspection$1", "isApplicable"));
                }
                if (contextType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/android/tools/idea/lint/AndroidLintConvertToWebpInspection$1", "isApplicable"));
                }
                return AndroidFacet.getInstance(startElement) != null;
            }

            @Override
            public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                if (startElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintConvertToWebpInspection$1", "apply"));
                }
                if (endElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintConvertToWebpInspection$1", "apply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/lint/AndroidLintConvertToWebpInspection$1", "apply"));
                }
                AndroidFacet facet = AndroidFacet.getInstance(startElement);
                if (facet != null) {
                    AndroidModuleInfo info = AndroidModuleInfo.get(facet);
                    int minSdkVersion = info.getMinSdkVersion().getApiLevel();
                    List<VirtualFile> folders = facet.getResourceFolderManager().getFolders();
                    ConvertToWebpAction action = new ConvertToWebpAction();
                    action.perform(startElement.getProject(), minSdkVersion, folders.toArray(VirtualFile.EMPTY_ARRAY));
                }
            }
        }};
        if (androidLintQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintConvertToWebpInspection", "getQuickFixes"));
        }
        return androidLintQuickFixArray;
    }
}

