/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintGradleDynamicVersionInspection
extends AndroidLintInspectionBase {
    public AndroidLintGradleDynamicVersionInspection() {
        super(AndroidBundle.message("android.lint.inspections.gradle.dynamic.version", new Object[0]), GradleDetector.PLUS);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(final @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        GradleCoordinate plus;
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintGradleDynamicVersionInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintGradleDynamicVersionInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintGradleDynamicVersionInspection", "getQuickFixes"));
        }
        String before = GradleDetector.getOldValue((Issue)GradleDetector.PLUS, (String)message, (TextFormat)TextFormat.RAW);
        if (before != null && before.contains("+") && (plus = GradleCoordinate.parseCoordinateString((String)before)) != null && plus.getArtifactId() != null) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with specific version", plus.getRevision(), "specific version"){

                @Override
                @Nullable
                protected String getNewValue() {
                    return RepositoryUrlManager.get().resolveDynamicCoordinateVersion(plus, startElement.getProject());
                }
            }};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintGradleDynamicVersionInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintGradleDynamicVersionInspection", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }
}

