/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.GridLayoutDetector;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidLintGridLayoutInspection
extends AndroidLintInspectionBase {
    public AndroidLintGridLayoutInspection() {
        super(AndroidBundle.message("android.lint.inspections.grid.layout", new Object[0]), GridLayoutDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(final @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintGridLayoutInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintGridLayoutInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintGridLayoutInspection", "getQuickFixes"));
        }
        String obsolete = GridLayoutDetector.getOldValue((String)message, (TextFormat)TextFormat.RAW);
        String available = GridLayoutDetector.getNewValue((String)message, (TextFormat)TextFormat.RAW);
        if (obsolete != null && available != null) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Update to " + available, obsolete, available){

                @Override
                protected void editBefore(@NotNull Document document) {
                    if (document == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/android/tools/idea/lint/AndroidLintGridLayoutInspection$1", "editBefore"));
                    }
                    Project project = startElement.getProject();
                    XmlFile file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlFile.class);
                    if (file != null) {
                        AndroidResourceUtil.ensureNamespaceImported(file, "http://schemas.android.com/apk/res-auto", null);
                        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                    }
                }
            }};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintGridLayoutInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintGridLayoutInspection", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }
}

