/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.RenameXmlTagQuickFix;
import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.NetworkSecurityConfigDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.RenameAttributeQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintNetworkSecurityConfigInspection
extends AndroidLintInspectionBase {
    public AndroidLintNetworkSecurityConfigInspection() {
        super(AndroidBundle.message("android.lint.inspections.network.security.config", new Object[0]), NetworkSecurityConfigDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintNetworkSecurityConfigInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintNetworkSecurityConfigInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintNetworkSecurityConfigInspection", "getQuickFixes"));
        }
        if (NetworkSecurityConfigDetector.isInvalidDigestAlgorithmMessage((String)message)) {
            List digestAlgs = NetworkSecurityConfigDetector.getSupportedPinDigestAlgorithms();
            AndroidLintQuickFix[] digestFixes = new AndroidLintQuickFix[digestAlgs.size()];
            for (int i = 0; i < digestFixes.length; ++i) {
                String algorithm = (String)digestAlgs.get(i);
                digestFixes[i] = new ReplaceStringQuickFix(String.format("Set digest to \"%1$s\"", algorithm), null, algorithm);
            }
            if (digestFixes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintNetworkSecurityConfigInspection", "getQuickFixes"));
            }
            return digestFixes;
        }
        if (NetworkSecurityConfigDetector.isAttributeSpellingError((String)message)) {
            XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
            XmlAttribute currentAttr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class, (boolean)false);
            assert (parentTag != null);
            assert (currentAttr != null);
            List suggestions = NetworkSecurityConfigDetector.getAttributeSpellingSuggestions((String)currentAttr.getName(), (String)parentTag.getName());
            AndroidLintQuickFix[] attrFixes = new AndroidLintQuickFix[suggestions.size()];
            for (int i = 0; i < attrFixes.length; ++i) {
                attrFixes[i] = new RenameAttributeQuickFix(null, (String)suggestions.get(i));
            }
            if (attrFixes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintNetworkSecurityConfigInspection", "getQuickFixes"));
            }
            return attrFixes;
        }
        if (NetworkSecurityConfigDetector.isTagSpellingError((String)message)) {
            XmlTag currentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
            assert (currentTag != null);
            XmlTag parentTag = currentTag.getParentTag();
            assert (parentTag != null);
            List suggestions = NetworkSecurityConfigDetector.getTagSpellingSuggestions((String)currentTag.getName(), (String)parentTag.getName());
            AndroidLintQuickFix[] elementQuickFixes = new AndroidLintQuickFix[suggestions.size()];
            for (int i = 0; i < elementQuickFixes.length; ++i) {
                elementQuickFixes[i] = new RenameXmlTagQuickFix((String)suggestions.get(i));
            }
            if (elementQuickFixes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintNetworkSecurityConfigInspection", "getQuickFixes"));
            }
            return elementQuickFixes;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintNetworkSecurityConfigInspection", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }
}

