/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.lint.checks.RtlDetector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintRtlCompatInspection
extends AndroidLintInspectionBase {
    private static final Pattern QUOTED_PARAMETER = Pattern.compile("`.+:(.+)=\"(.*)\"`");

    public AndroidLintRtlCompatInspection() {
        super(AndroidBundle.message("android.lint.inspections.rtl.compat", new Object[0]), RtlDetector.COMPAT);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
        Matcher matcher;
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintRtlCompatInspection", "getQuickFixes"));
        }
        if (message.startsWith("To support older versions than API 17") && (matcher = QUOTED_PARAMETER.matcher(message)).find()) {
            String name = matcher.group(1);
            String value = matcher.group(2);
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix(String.format("Set %s", name), name, value)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintRtlCompatInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintRtlCompatInspection", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }
}

