/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintSwitchIntDefInspection
extends AndroidLintInspectionBase {
    public AndroidLintSwitchIntDefInspection() {
        super(AndroidBundle.message("android.lint.inspections.switch.int.def", new Object[0]), AnnotationDetector.SWITCH_TYPE_DEF);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection", "getQuickFixes"));
        }
        final List missingCases = AnnotationDetector.getMissingCases((String)message, (TextFormat)TextFormat.RAW);
        if (missingCases != null && !missingCases.isEmpty()) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new AndroidLintQuickFix(){

                @Override
                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    if (startElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection$1", "apply"));
                    }
                    if (endElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection$1", "apply"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection$1", "apply"));
                    }
                    if (startElement.getParent() instanceof PsiSwitchStatement) {
                        PsiSwitchStatement switchStatement = (PsiSwitchStatement)startElement.getParent();
                        Project project = switchStatement.getProject();
                        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                        PsiCodeBlock body = switchStatement.getBody();
                        if (body == null) {
                            return;
                        }
                        PsiElement anchor = body.getLastChild();
                        for (String constant : missingCases) {
                            PsiElement parent = anchor.getParent();
                            PsiStatement caseStatement = factory.createStatementFromText("case " + constant + ":", anchor);
                            parent.addBefore((PsiElement)caseStatement, anchor);
                            PsiStatement breakStatement = factory.createStatementFromText("break;", anchor);
                            parent.addBefore((PsiElement)breakStatement, anchor);
                        }
                        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)switchStatement);
                    }
                }

                @Override
                public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                    if (startElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection$1", "isApplicable"));
                    }
                    if (endElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection$1", "isApplicable"));
                    }
                    if (contextType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection$1", "isApplicable"));
                    }
                    return startElement.isValid();
                }

                @Override
                @NotNull
                public String getName() {
                    if ("Add Missing @IntDef Constants" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection$1", "getName"));
                    }
                    return "Add Missing @IntDef Constants";
                }
            }};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }
}

