/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.gpu.gfxinfohandlers;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tools.adtui.TimelineData;
import com.android.tools.idea.monitor.gpu.GpuSampler;
import com.android.tools.idea.monitor.gpu.gfxinfohandlers.GfxinfoHandler;
import com.intellij.util.ThreeState;
import gnu.trove.TFloatArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JHandler
implements GfxinfoHandler {
    public static final int MIN_API_LEVEL = 16;
    private ProcessStatReceiver myReceiver = new ProcessStatReceiver();
    private long myLastSampleTime;
    private boolean myDelimiterAdded = true;
    private boolean myIgnoreInitialSamples = true;

    @Override
    public boolean accept(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/JHandler", "accept"));
        }
        return GpuSampler.decodeApiLevel(client) >= 16;
    }

    @Override
    public void setClient(@Nullable Client client) {
        this.myLastSampleTime = System.currentTimeMillis();
        this.myReceiver.reset();
        this.myDelimiterAdded = true;
        this.myIgnoreInitialSamples = true;
    }

    @Override
    public void sample(@NotNull IDevice device, @NotNull ClientData data, @NotNull TimelineData timeline) throws Exception {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/JHandler", "sample"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/JHandler", "sample"));
        }
        if (timeline == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeline", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/JHandler", "sample"));
        }
        int pid = data.getPid();
        long currentTime = System.currentTimeMillis();
        this.myReceiver.resetSamples();
        device.executeShellCommand("dumpsys gfxinfo " + pid, (IShellOutputReceiver)this.myReceiver, 1L, TimeUnit.SECONDS);
        long timeDelta = currentTime - this.myLastSampleTime;
        if (this.myReceiver.getLogSize() > 0) {
            if (this.myDelimiterAdded) {
                timeline.add(this.myLastSampleTime, 1, new float[]{0.0f, 0.0f, 0.0f});
                this.myDelimiterAdded = false;
            }
            if (!this.myIgnoreInitialSamples) {
                for (int i = 0; i < this.myReceiver.getLogSize(); ++i) {
                    long time = timeDelta * (long)(i + 1) / (long)this.myReceiver.getLogSize() + this.myLastSampleTime;
                    timeline.add(time, 1, new float[]{this.myReceiver.getDrawTime(i).floatValue(), this.myReceiver.getPrepareTime(i).floatValue(), this.myReceiver.getExecuteTime(i).floatValue()});
                }
            }
            this.myIgnoreInitialSamples = false;
        } else {
            if (!this.myDelimiterAdded) {
                timeline.add(this.myLastSampleTime, 1, new float[]{0.0f, 0.0f, 0.0f});
                this.myDelimiterAdded = true;
            }
            timeline.add(currentTime, 1, new float[]{0.0f, 0.0f, 0.0f});
        }
        this.myLastSampleTime = currentTime;
    }

    @Override
    @NotNull
    public TimelineData createTimelineData() {
        TimelineData timelineData = new TimelineData(3, 8192);
        if (timelineData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/JHandler", "createTimelineData"));
        }
        return timelineData;
    }

    @Override
    public ThreeState getIsEnabledOnDevice(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/JHandler", "getIsEnabledOnDevice"));
        }
        return JHandler.parseIsEnabledOnDevice(device);
    }

    public static ThreeState parseIsEnabledOnDevice(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/JHandler", "parseIsEnabledOnDevice"));
        }
        Future result = device.getSystemProperty("debug.hwui.profile");
        try {
            String resultString = (String)result.get(100L, TimeUnit.MILLISECONDS);
            return ThreeState.fromBoolean(("true".equals(resultString) || "visual_bars".equals(resultString) ? 1 : 0) != 0);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return ThreeState.UNSURE;
    }

    private static final class ProcessStatReceiver
    extends MultiLineReceiver {
        private List<String> myOutput = new ArrayList<String>();
        private TFloatArrayList myDrawTimes = new TFloatArrayList();
        private TFloatArrayList myPrepareTimes = new TFloatArrayList();
        private TFloatArrayList myExecuteTimes = new TFloatArrayList();

        private ProcessStatReceiver() {
        }

        public void reset() {
            this.resetSamples();
        }

        public void resetSamples() {
            this.myOutput.clear();
            this.myDrawTimes.resetQuick();
            this.myPrepareTimes.resetQuick();
            this.myExecuteTimes.resetQuick();
        }

        public int getLogSize() {
            return this.myExecuteTimes.size();
        }

        @Nullable
        public Float getDrawTime(int index) {
            return Float.valueOf(this.myDrawTimes.get(index));
        }

        @Nullable
        public Float getPrepareTime(int index) {
            return Float.valueOf(this.myPrepareTimes.get(index));
        }

        @Nullable
        public Float getExecuteTime(int index) {
            return Float.valueOf(this.myExecuteTimes.get(index));
        }

        public boolean isCancelled() {
            return false;
        }

        public void processNewLines(@NotNull String[] lines) {
            if (lines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/JHandler$ProcessStatReceiver", "processNewLines"));
            }
            this.myOutput.addAll(Arrays.asList(lines));
        }

        public void done() {
            String line;
            super.done();
            block2: for (int profileSectionIndex = 0; profileSectionIndex < this.myOutput.size(); ++profileSectionIndex) {
                if (!this.myOutput.get(profileSectionIndex).startsWith("Profile data in ms:")) continue;
                ++profileSectionIndex;
                while (profileSectionIndex < this.myOutput.size()) {
                    String[] tokens = this.myOutput.get(profileSectionIndex).split("\\s+");
                    if (tokens.length == 3 && "Draw".equals(tokens[0]) && "Process".equals(tokens[1]) && "Execute".equals(tokens[2])) {
                        ++profileSectionIndex;
                        break block2;
                    }
                    ++profileSectionIndex;
                }
                break;
            }
            for (int i = profileSectionIndex; i < this.myOutput.size() && !(line = this.myOutput.get(i)).startsWith("View hierarchy:"); ++i) {
                String[] timings = line.split("\\s+");
                if (timings.length != 3) continue;
                try {
                    this.myDrawTimes.add(Float.parseFloat(timings[0]));
                    this.myPrepareTimes.add(Float.parseFloat(timings[1]));
                    this.myExecuteTimes.add(Float.parseFloat(timings[2]));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

