/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.network.model;

import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.profilerclient.DeviceProfilerService;
import com.android.tools.idea.monitor.ui.network.model.HttpData;
import com.android.tools.idea.monitor.ui.network.model.HttpDataCache;
import com.android.tools.idea.monitor.ui.network.model.NetworkCaptureModel;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class RpcNetworkCaptureModel
implements NetworkCaptureModel {
    @NotNull
    private final NetworkServiceGrpc.NetworkServiceBlockingStub myNetworkService;
    @NotNull
    private final HttpDataCache myDataCache;
    private final int myPid;

    public RpcNetworkCaptureModel(@NotNull DeviceProfilerService service, @NotNull HttpDataCache dataCache) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/android/tools/idea/monitor/ui/network/model/RpcNetworkCaptureModel", "<init>"));
        }
        if (dataCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataCache", "com/android/tools/idea/monitor/ui/network/model/RpcNetworkCaptureModel", "<init>"));
        }
        this.myNetworkService = service.getNetworkService();
        this.myDataCache = dataCache;
        this.myPid = service.getSelectedProcessId();
    }

    @Override
    @NotNull
    public List<HttpData> getData(@NotNull Range timeCurrentRangeUs) {
        NetworkProfiler.HttpRangeResponse response;
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/network/model/RpcNetworkCaptureModel", "getData"));
        }
        NetworkProfiler.HttpRangeRequest request = NetworkProfiler.HttpRangeRequest.newBuilder().setAppId(this.myPid).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax())).build();
        try {
            response = this.myNetworkService.getHttpRange(request);
        }
        catch (StatusRuntimeException e) {
            List<HttpData> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/network/model/RpcNetworkCaptureModel", "getData"));
            }
            return list;
        }
        ArrayList<HttpData> httpDataList = new ArrayList<HttpData>(response.getDataList().size());
        for (NetworkProfiler.HttpConnectionData connection : response.getDataList()) {
            HttpData httpData = new HttpData();
            httpData.setId(connection.getConnId());
            httpData.setStartTimeUs(TimeUnit.NANOSECONDS.toMicros(connection.getStartTimestamp()));
            this.requestHttpRequest(httpData);
            if (connection.getEndTimestamp() != 0L) {
                httpData.setEndTimeUs(TimeUnit.NANOSECONDS.toMicros(connection.getEndTimestamp()));
                httpData.setDownloadingTimeUs(TimeUnit.NANOSECONDS.toMicros(connection.getDownloadingTimestamp()));
                this.requestHttpResponseBody(httpData);
            }
            httpDataList.add(httpData);
        }
        ArrayList<HttpData> arrayList = httpDataList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/network/model/RpcNetworkCaptureModel", "getData"));
        }
        return arrayList;
    }

    private void requestHttpRequest(@NotNull HttpData data) {
        NetworkProfiler.HttpDetailsResponse.Request result;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/monitor/ui/network/model/RpcNetworkCaptureModel", "requestHttpRequest"));
        }
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(data.getId()).setType(NetworkProfiler.HttpDetailsRequest.Type.REQUEST).build();
        try {
            result = this.myNetworkService.getHttpDetails(request).getRequest();
        }
        catch (StatusRuntimeException e) {
            return;
        }
        data.setUrl(result.getUrl());
        data.setMethod(result.getMethod());
    }

    private void requestHttpResponseBody(@NotNull HttpData data) {
        NetworkProfiler.HttpDetailsResponse response;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/monitor/ui/network/model/RpcNetworkCaptureModel", "requestHttpResponseBody"));
        }
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(data.getId()).setType(NetworkProfiler.HttpDetailsRequest.Type.RESPONSE_BODY).build();
        try {
            response = this.myNetworkService.getHttpDetails(request);
        }
        catch (StatusRuntimeException e) {
            return;
        }
        String responseFilePath = response.getResponseBody().getPayloadId();
        data.setHttpResponsePayloadId(responseFilePath);
    }
}

