/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.ConfigurationSpecificEditor;
import com.android.tools.idea.run.editor.DefaultActivityLaunch;
import com.android.tools.idea.run.editor.InstallOption;
import com.android.tools.idea.run.editor.LaunchConfigurableWrapper;
import com.android.tools.idea.run.editor.LaunchOption;
import com.android.tools.idea.run.editor.LaunchOptionConfigurableContext;
import com.android.tools.idea.run.editor.LaunchOptionState;
import com.android.tools.idea.run.editor.NoLaunch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactType;
import org.jetbrains.annotations.NotNull;

public class ApplicationRunParameters<T extends AndroidRunConfiguration>
implements ConfigurationSpecificEditor<T>,
ActionListener {
    private JPanel myPanel;
    private ComboBox myDeployOptionCombo;
    private LabeledComponent<ComboBox> myCustomArtifactLabeledComponent;
    private final ComboBox myArtifactCombo;
    private LabeledComponent<JBTextField> myPmOptionsLabeledComponent;
    private ComboBox myLaunchOptionCombo;
    private ConfigurableCardPanel myLaunchOptionsCardPanel;
    private LabeledComponent<JBTextField> myAmOptionsLabeledComponent;
    private final Project myProject;
    private final ConfigurationModuleSelector myModuleSelector;
    private Artifact myLastSelectedArtifact;
    private final ImmutableMap<String, LaunchConfigurableWrapper> myConfigurables;

    public ApplicationRunParameters(Project project, ConfigurationModuleSelector moduleSelector) {
        this.myProject = project;
        this.myModuleSelector = moduleSelector;
        this.$$$setupUI$$$();
        this.myDeployOptionCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(Arrays.asList(InstallOption.values())));
        this.myDeployOptionCombo.setRenderer((ListCellRenderer)((Object)new InstallOption.Renderer()));
        this.myDeployOptionCombo.addActionListener((ActionListener)this);
        this.myDeployOptionCombo.setSelectedItem((Object)InstallOption.DEFAULT_APK);
        this.myArtifactCombo = (ComboBox)this.myCustomArtifactLabeledComponent.getComponent();
        this.myArtifactCombo.setRenderer((ListCellRenderer)((Object)new ArtifactRenderer()));
        this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(this.getAndroidArtifacts().toArray()));
        this.myArtifactCombo.addActionListener((ActionListener)this);
        ((JBTextField)this.myPmOptionsLabeledComponent.getComponent()).getEmptyText().setText("Options to 'pm install' command");
        this.myLaunchOptionCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(AndroidRunConfiguration.LAUNCH_OPTIONS));
        this.myLaunchOptionCombo.setRenderer((ListCellRenderer)((Object)new LaunchOption.Renderer()));
        this.myLaunchOptionCombo.addActionListener((ActionListener)this);
        ((JBTextField)this.myAmOptionsLabeledComponent.getComponent()).getEmptyText().setText("Options to 'am start' command");
        LaunchOptionConfigurableContext context = new LaunchOptionConfigurableContext(){

            @Override
            public Module getModule() {
                return ApplicationRunParameters.this.myModuleSelector.getModule();
            }
        };
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (LaunchOption launchOption : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            builder.put((Object)launchOption.getId(), (Object)new LaunchConfigurableWrapper(project, context, launchOption));
        }
        this.myConfigurables = builder.build();
        this.myLaunchOptionCombo.setSelectedItem((Object)DefaultActivityLaunch.INSTANCE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.myDeployOptionCombo) {
            InstallOption option = (InstallOption)((Object)this.myDeployOptionCombo.getSelectedItem());
            this.myCustomArtifactLabeledComponent.setVisible(option == InstallOption.CUSTOM_ARTIFACT);
            this.myPmOptionsLabeledComponent.setVisible(option != InstallOption.NOTHING);
            if (option == InstallOption.CUSTOM_ARTIFACT) {
                this.updateBuildArtifactBeforeRunSetting();
            }
        } else if (source == this.myArtifactCombo) {
            this.updateBuildArtifactBeforeRunSetting();
        } else if (source == this.myLaunchOptionCombo) {
            LaunchOption option = (LaunchOption)this.myLaunchOptionCombo.getSelectedItem();
            this.myAmOptionsLabeledComponent.setVisible(option != NoLaunch.INSTANCE);
            this.myLaunchOptionsCardPanel.select(this.myConfigurables.get((Object)option.getId()), true);
        }
    }

    public Module getModule() {
        return this.myModuleSelector.getModule();
    }

    @NotNull
    private static InstallOption getDeployOption(boolean deploy, String artifactName) {
        if (!deploy) {
            InstallOption installOption = InstallOption.NOTHING;
            if (installOption == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/ApplicationRunParameters", "getDeployOption"));
            }
            return installOption;
        }
        InstallOption installOption = StringUtil.isEmpty((String)artifactName) ? InstallOption.DEFAULT_APK : InstallOption.CUSTOM_ARTIFACT;
        if (installOption == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/ApplicationRunParameters", "getDeployOption"));
        }
        return installOption;
    }

    @Override
    public void resetFrom(@NotNull AndroidRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/run/editor/ApplicationRunParameters", "resetFrom"));
        }
        InstallOption installOption = ApplicationRunParameters.getDeployOption(configuration.DEPLOY, configuration.ARTIFACT_NAME);
        this.myDeployOptionCombo.setSelectedItem((Object)installOption);
        if (installOption == InstallOption.CUSTOM_ARTIFACT) {
            String artifactName = StringUtil.notNullize((String)configuration.ARTIFACT_NAME);
            ArrayList arrayList = Lists.newArrayList(this.getAndroidArtifacts());
            Artifact selectedArtifact = ApplicationRunParameters.findArtifactByName(arrayList, artifactName);
            if (selectedArtifact != null) {
                this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                this.myArtifactCombo.setSelectedItem((Object)selectedArtifact);
            } else {
                ArrayList items = Lists.newArrayList((Object[])arrayList.toArray());
                items.add(artifactName);
                this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
                this.myArtifactCombo.setSelectedItem((Object)artifactName);
            }
        }
        ((JBTextField)this.myPmOptionsLabeledComponent.getComponent()).setText(configuration.PM_INSTALL_OPTIONS);
        for (LaunchOption launchOption : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            LaunchOptionState state = configuration.getLaunchOptionState(launchOption.getId());
            assert (state != null) : "State is null for option: " + launchOption.getDisplayName();
            ((LaunchConfigurableWrapper)this.myConfigurables.get((Object)launchOption.getId())).resetFrom(state);
        }
        LaunchOption launchOption = ApplicationRunParameters.getLaunchOption(configuration.MODE);
        this.myLaunchOptionCombo.setSelectedItem((Object)launchOption);
        ((JBTextField)this.myAmOptionsLabeledComponent.getComponent()).setText(configuration.ACTIVITY_EXTRA_FLAGS);
    }

    @NotNull
    private static LaunchOption getLaunchOption(String mode) {
        if (StringUtil.isEmpty((String)mode)) {
            mode = DefaultActivityLaunch.INSTANCE.getId();
        }
        for (LaunchOption launchOption : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            if (!launchOption.getId().equals(mode)) continue;
            LaunchOption launchOption2 = launchOption;
            if (launchOption2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/ApplicationRunParameters", "getLaunchOption"));
            }
            return launchOption2;
        }
        throw new IllegalStateException("Unexpected error determining launch mode");
    }

    @Override
    public void applyTo(@NotNull AndroidRunConfiguration configuration) {
        Iterator<? extends LaunchOption> item;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/run/editor/ApplicationRunParameters", "applyTo"));
        }
        InstallOption installOption = (InstallOption)((Object)this.myDeployOptionCombo.getSelectedItem());
        configuration.DEPLOY = installOption != InstallOption.NOTHING;
        configuration.ARTIFACT_NAME = "";
        if (installOption == InstallOption.CUSTOM_ARTIFACT && (item = ((ComboBox)this.myCustomArtifactLabeledComponent.getComponent()).getSelectedItem()) instanceof Artifact) {
            configuration.ARTIFACT_NAME = ((Artifact)item).getName();
        }
        configuration.PM_INSTALL_OPTIONS = StringUtil.notNullize((String)((JBTextField)this.myPmOptionsLabeledComponent.getComponent()).getText());
        for (LaunchOption launchOption : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            LaunchOptionState state = configuration.getLaunchOptionState(launchOption.getId());
            assert (state != null) : "State is null for option: " + launchOption.getDisplayName();
            ((LaunchConfigurableWrapper)this.myConfigurables.get((Object)launchOption.getId())).applyTo(state);
        }
        LaunchOption launchOption = (LaunchOption)this.myLaunchOptionCombo.getSelectedItem();
        configuration.MODE = launchOption.getId();
        configuration.ACTIVITY_EXTRA_FLAGS = StringUtil.notNullize((String)((JBTextField)this.myAmOptionsLabeledComponent.getComponent()).getText());
    }

    @Override
    public Component getComponent() {
        return this.myPanel;
    }

    public JComponent getAnchor() {
        return null;
    }

    public void setAnchor(JComponent anchor) {
    }

    private void updateBuildArtifactBeforeRunSetting() {
        Artifact newArtifact = null;
        Object item = this.myArtifactCombo.getSelectedItem();
        if (item instanceof Artifact) {
            newArtifact = (Artifact)item;
        }
        if (Comparing.equal((Object)newArtifact, (Object)this.myLastSelectedArtifact)) {
            return;
        }
        if (this.myLastSelectedArtifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption((JComponent)this.myPanel, (Project)this.myProject, (Artifact)this.myLastSelectedArtifact, (boolean)false);
        }
        if (newArtifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption((JComponent)this.myPanel, (Project)this.myProject, (Artifact)newArtifact, (boolean)true);
        }
        if (this.myLastSelectedArtifact == null || newArtifact == null) {
            this.addOrRemoveMakeTask(newArtifact == null);
        }
        this.myLastSelectedArtifact = newArtifact;
    }

    private void addOrRemoveMakeTask(boolean add) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myPanel);
        ConfigurationSettingsEditorWrapper editor = (ConfigurationSettingsEditorWrapper)ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.getData(dataContext);
        if (editor == null) {
            return;
        }
        ArrayList<BeforeRunTask> makeTasks = new ArrayList<BeforeRunTask>();
        for (BeforeRunTask task : editor.getStepsBeforeLaunch()) {
            if (!(task instanceof CompileStepBeforeRun.MakeBeforeRunTask) && !(task instanceof CompileStepBeforeRunNoErrorCheck.MakeBeforeRunTaskNoErrorCheck)) continue;
            makeTasks.add(task);
        }
        if (add) {
            if (makeTasks.size() == 0) {
                editor.addBeforeLaunchStep((BeforeRunTask)new CompileStepBeforeRun.MakeBeforeRunTask());
            } else {
                for (BeforeRunTask task : makeTasks) {
                    task.setEnabled(true);
                }
            }
        } else {
            for (BeforeRunTask task : makeTasks) {
                task.setEnabled(false);
            }
        }
    }

    @NotNull
    private Collection<? extends Artifact> getAndroidArtifacts() {
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
        Collection<Object> collection = artifactManager == null ? Collections.emptyList() : artifactManager.getArtifactsByType(AndroidApplicationArtifactType.getInstance());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/ApplicationRunParameters", "getAndroidArtifacts"));
        }
        return collection;
    }

    private static Artifact findArtifactByName(@NotNull List<Artifact> artifacts, @NotNull String artifactName) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/android/tools/idea/run/editor/ApplicationRunParameters", "findArtifactByName"));
        }
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/android/tools/idea/run/editor/ApplicationRunParameters", "findArtifactByName"));
        }
        for (Artifact artifact : artifacts) {
            if (!artifactName.equals(artifact.getName())) continue;
            return artifact;
        }
        return null;
    }

    public void onModuleChanged() {
        Module currentModule = this.myModuleSelector.getModule();
        if (currentModule == null) {
            return;
        }
        AndroidModuleModel model = AndroidModuleModel.get(currentModule);
        boolean isInstantApp = false;
        if (model != null && model.getProjectType() == 4) {
            this.myLaunchOptionCombo.setSelectedItem((Object)"launch_deep_link");
            this.myDeployOptionCombo.setSelectedItem((Object)InstallOption.DEFAULT_APK);
            isInstantApp = true;
        }
        this.myDeployOptionCombo.setEnabled(!isInstantApp);
        this.myCustomArtifactLabeledComponent.setEnabled(!isInstantApp);
        this.myLaunchOptionCombo.setEnabled(!isInstantApp);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        ConfigurableCardPanel configurableCardPanel;
        LabeledComponent labeledComponent2;
        ComboBox comboBox;
        ComboBox comboBox2;
        LabeledComponent labeledComponent3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Installation Options");
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Deploy:");
        jBLabel.setDisplayedMnemonic('D');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myCustomArtifactLabeledComponent = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setComponentClass("com.intellij.openapi.ui.ComboBox");
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText("&Artifact");
        jPanel.add((Component)labeledComponent3, new GridConstraints(2, 0, 1, 3, 0, 1, 3, 3, null, null, null, 2));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Launch Options");
        jPanel.add((Component)titledSeparator2, new GridConstraints(4, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Launch:");
        jBLabel2.setDisplayedMnemonic('L');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myLaunchOptionCombo = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myDeployOptionCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, new Dimension(100, -1), null, null));
        this.myPmOptionsLabeledComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.ui.components.JBTextField");
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText("&Install Flags");
        jPanel.add((Component)labeledComponent2, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null, 2));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLaunchOptionsCardPanel = configurableCardPanel = new ConfigurableCardPanel();
        jPanel.add((Component)configurableCardPanel, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null, 2));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAmOptionsLabeledComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.ui.components.JBTextField");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Launch &Flags");
        jPanel.add((Component)labeledComponent, new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, null, null, 2));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class ArtifactRenderer
    extends ListCellRendererWrapper {
        private ArtifactRenderer() {
        }

        public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof Artifact) {
                Artifact artifact = (Artifact)value;
                this.setText(artifact.getName());
                this.setIcon(artifact.getArtifactType().getIcon());
            } else if (value instanceof String) {
                this.setText("<html><font color='red'>" + value + "</font></html>");
            }
        }
    }
}

