/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.tools.idea.sdk.install.patch.PatchInstaller;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.lang.UrlClassLoader;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchRunner {
    private static final String PATCHER_JAR_FN = "patcher.jar";
    private static final String RUNNER_CLASS_NAME = "com.intellij.updater.Runner";
    private static final String UPDATER_UI_CLASS_NAME = "com.intellij.updater.UpdaterUI";
    private static final String REPO_UI_CLASS_NAME = "com.android.tools.idea.sdk.updater.RepoUpdaterUI";
    private static final String PATCH_GENERATOR_CLASS_NAME = "com.android.tools.idea.sdk.updater.PatchGenerator";
    private final Class myRunnerClass;
    private final Class myUiBaseClass;
    private final Class myUiClass;
    private final Class myGeneratorClass;
    private final File myPatcherJar;
    private static Map<LocalPackage, PatchRunner> ourCache = new WeakHashMap();

    @Nullable
    public static PatchRunner getPatchRunner(@NotNull LocalPackage runnerPackage, @NotNull ProgressIndicator progress, @NotNull FileOp fop) {
        if (runnerPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnerPackage", "com/android/tools/idea/sdk/install/patch/PatchRunner", "getPatchRunner"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/patch/PatchRunner", "getPatchRunner"));
        }
        if (fop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/sdk/install/patch/PatchRunner", "getPatchRunner"));
        }
        PatchRunner result = ourCache.get(runnerPackage);
        if (result != null) {
            return result;
        }
        try {
            File patcherFile = PatchRunner.getPatcherFile(runnerPackage, fop);
            if (patcherFile == null) {
                progress.logWarning("Failed to find patcher JAR!");
                return null;
            }
            ClassLoader loader = PatchRunner.getClassLoader(patcherFile, progress);
            Class<?> runnerClass = Class.forName(RUNNER_CLASS_NAME, true, loader);
            Class<?> uiBaseClass = Class.forName(UPDATER_UI_CLASS_NAME, true, loader);
            Class<?> uiClass = Class.forName(REPO_UI_CLASS_NAME, true, loader);
            Class<?> generatorClass = Class.forName(PATCH_GENERATOR_CLASS_NAME, true, loader);
            result = new PatchRunner(patcherFile, runnerClass, uiBaseClass, uiClass, generatorClass);
        }
        catch (ClassNotFoundException e) {
            progress.logWarning("Failed to load patcher classes!");
            return null;
        }
        ourCache.put(runnerPackage, result);
        return result;
    }

    public boolean run(@NotNull File destination, @NotNull File patchFile, @NotNull ProgressIndicator progress) throws RestartRequiredException {
        Method doInstall;
        Object ui;
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/sdk/install/patch/PatchRunner", "run"));
        }
        if (patchFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchFile", "com/android/tools/idea/sdk/install/patch/PatchRunner", "run"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/patch/PatchRunner", "run"));
        }
        try {
            ui = this.myUiClass.getConstructor(Component.class, ProgressIndicator.class).newInstance(null, progress);
        }
        catch (ReflectiveOperationException e) {
            progress.logWarning("Failed to create updater UI!", (Throwable)e);
            return false;
        }
        try {
            Method initLogger = this.myRunnerClass.getMethod("initLogger", new Class[0]);
            initLogger.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            progress.logWarning("Failed to initialize logger!", (Throwable)e);
            return false;
        }
        try {
            doInstall = this.myRunnerClass.getMethod("doInstall", String.class, this.myUiBaseClass, String.class);
        }
        catch (Throwable e) {
            progress.logWarning("Failed to find main method in runner!", e);
            return false;
        }
        try {
            progress.logInfo("Running patcher...");
            if (!((Boolean)doInstall.invoke(null, patchFile.getPath(), ui, destination.getPath())).booleanValue()) {
                progress.logWarning("Failed to apply patch");
                return false;
            }
            progress.logInfo("Patch applied.");
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RestartRequiredException) {
                throw (RestartRequiredException)e.getTargetException();
            }
            progress.logWarning("Failed to run patcher", (Throwable)e);
            return false;
        }
        catch (Throwable e) {
            progress.logWarning("Failed to run patcher", e);
            return false;
        }
        return true;
    }

    public boolean generatePatch(@Nullable File existingRoot, @NotNull File newRoot, @Nullable String existingDescription, @NotNull String newDescription, @NotNull File destination, @NotNull ProgressIndicator progress) {
        if (newRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRoot", "com/android/tools/idea/sdk/install/patch/PatchRunner", "generatePatch"));
        }
        if (newDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDescription", "com/android/tools/idea/sdk/install/patch/PatchRunner", "generatePatch"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/sdk/install/patch/PatchRunner", "generatePatch"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/patch/PatchRunner", "generatePatch"));
        }
        try {
            Method generateMethod = this.myGeneratorClass.getMethod("generateFullPackage", File.class, File.class, File.class, String.class, String.class, ProgressIndicator.class);
            return (Boolean)generateMethod.invoke(null, newRoot, existingRoot, destination, existingDescription, newDescription, progress);
        }
        catch (NoSuchMethodException e) {
            progress.logWarning("Patcher doesn't support full package generation!");
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable reason = e.getTargetException();
            progress.logWarning("Patch invocation failed! " + reason);
            if (reason != null) {
                reason.printStackTrace();
            }
            return false;
        }
        catch (IllegalAccessException e) {
            progress.logWarning("Patch generation failed!");
            return false;
        }
    }

    @Nullable
    private static File getPatcherFile(@Nullable LocalPackage patcherPackage, @NotNull FileOp fop) {
        if (fop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/sdk/install/patch/PatchRunner", "getPatcherFile"));
        }
        File patcherFile = patcherPackage == null ? null : new File(patcherPackage.getLocation(), PATCHER_JAR_FN);
        return patcherFile != null && fop.exists(patcherFile) ? patcherFile : null;
    }

    @VisibleForTesting
    PatchRunner(@NotNull File jarFile, @NotNull Class runnerClass, @NotNull Class uiBaseClass, @NotNull Class uiClass, @NotNull Class generatorClass) throws ClassNotFoundException {
        if (jarFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFile", "com/android/tools/idea/sdk/install/patch/PatchRunner", "<init>"));
        }
        if (runnerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnerClass", "com/android/tools/idea/sdk/install/patch/PatchRunner", "<init>"));
        }
        if (uiBaseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiBaseClass", "com/android/tools/idea/sdk/install/patch/PatchRunner", "<init>"));
        }
        if (uiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiClass", "com/android/tools/idea/sdk/install/patch/PatchRunner", "<init>"));
        }
        if (generatorClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatorClass", "com/android/tools/idea/sdk/install/patch/PatchRunner", "<init>"));
        }
        this.myPatcherJar = jarFile;
        this.myRunnerClass = runnerClass;
        this.myUiBaseClass = uiBaseClass;
        this.myUiClass = uiClass;
        this.myGeneratorClass = generatorClass;
    }

    @NotNull
    private static ClassLoader getClassLoader(@NotNull File patcherJar, @NotNull ProgressIndicator progress) {
        UrlClassLoader loader;
        if (patcherJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patcherJar", "com/android/tools/idea/sdk/install/patch/PatchRunner", "getClassLoader"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/patch/PatchRunner", "getClassLoader"));
        }
        try {
            loader = UrlClassLoader.build().urls(new URL[]{patcherJar.toURI().toURL()}).parent(PatchInstaller.class.getClassLoader()).get();
        }
        catch (MalformedURLException e) {
            throw new AssertionError("Failed to create URL from file: " + patcherJar, e);
        }
        UrlClassLoader urlClassLoader = loader;
        if (urlClassLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchRunner", "getClassLoader"));
        }
        return urlClassLoader;
    }

    @NotNull
    public File getPatcherJar() {
        File file = this.myPatcherJar;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchRunner", "getPatcherJar"));
        }
        return file;
    }

    public static class RestartRequiredException
    extends RuntimeException {
    }
}

