/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.core;

import com.android.tools.idea.ui.properties.core.OptionalProperty;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptionalValueProperty<T>
extends OptionalProperty<T> {
    @NotNull
    private Optional<T> myOptional;

    public OptionalValueProperty() {
        this.myOptional = Optional.empty();
    }

    public OptionalValueProperty(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/core/OptionalValueProperty", "<init>"));
        }
        this.myOptional = Optional.of(value);
    }

    public static <T> OptionalValueProperty<T> of(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/core/OptionalValueProperty", "of"));
        }
        return new OptionalValueProperty<T>(value);
    }

    public static <T> OptionalValueProperty<T> fromNullable(@Nullable T value) {
        if (value != null) {
            return OptionalValueProperty.of(value);
        }
        return OptionalValueProperty.absent();
    }

    public static <T> OptionalValueProperty<T> absent() {
        return new OptionalValueProperty<T>();
    }

    @Override
    @NotNull
    public Optional<T> get() {
        Optional<T> optional = this.myOptional;
        if (optional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/core/OptionalValueProperty", "get"));
        }
        return optional;
    }

    @Override
    protected void setDirectly(@NotNull Optional<T> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/core/OptionalValueProperty", "setDirectly"));
        }
        this.myOptional = value;
    }
}

