/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.swing;

import com.android.tools.idea.ui.properties.core.OptionalProperty;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Optional;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;

public final class SelectedItemProperty<T>
extends OptionalProperty<T>
implements ActionListener {
    @NotNull
    private JComboBox myComboBox;

    public SelectedItemProperty(@NotNull JComboBox comboBox) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/android/tools/idea/ui/properties/swing/SelectedItemProperty", "<init>"));
        }
        this.myComboBox = comboBox;
        this.myComboBox.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.notifyInvalidated();
    }

    @Override
    @NotNull
    public Optional<T> get() {
        Optional<Object> optional = Optional.ofNullable(this.myComboBox.getSelectedItem());
        if (optional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/swing/SelectedItemProperty", "get"));
        }
        return optional;
    }

    @Override
    protected void setDirectly(@NotNull Optional<T> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/swing/SelectedItemProperty", "setDirectly"));
        }
        this.myComboBox.setSelectedItem(value.orElse(null));
    }
}

