/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.actions.ConvertToConstraintLayoutForm;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintModel;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.sherpa.scout.Scout;
import com.android.tools.sherpa.structure.WidgetsScene;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToConstraintLayoutAction
extends AnAction
implements ModelListener {
    public static final String TITLE = "Convert to ConstraintLayout";
    public static final boolean ENABLED = true;
    public static final String ATTR_LAYOUT_CONVERSION_ABSOLUTE_X = "layout_conversion_absoluteX";
    public static final String ATTR_LAYOUT_CONVERSION_ABSOLUTE_Y = "layout_conversion_absoluteY";
    public static final String ATTR_LAYOUT_CONVERSION_ABSOLUTE_WIDTH = "layout_conversion_absoluteWidth";
    public static final String ATTR_LAYOUT_CONVERSION_ABSOLUTE_HEIGHT = "layout_conversion_absoluteHeight";
    private final DesignSurface mySurface;

    public ConvertToConstraintLayoutAction(@NotNull DesignSurface surface) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/actions/ConvertToConstraintLayoutAction", "<init>"));
        }
        super(TITLE, TITLE, null);
        this.mySurface = surface;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        NlComponent target = ConvertToConstraintLayoutAction.findTarget(screenView);
        if (target != null) {
            String tagName = target.getTagName();
            if (target.isOrHasSuperclass("android.support.constraint.ConstraintLayout")) {
                presentation.setVisible(false);
                return;
            }
            presentation.setVisible(true);
            tagName = tagName.substring(tagName.lastIndexOf(46) + 1);
            presentation.setText("Convert " + tagName + " to ConstraintLayout");
            presentation.setEnabled(true);
        } else {
            presentation.setText(TITLE);
            presentation.setEnabled(false);
            presentation.setVisible(true);
        }
    }

    @Nullable
    private static NlComponent findTarget(@Nullable ScreenView screenView) {
        List<NlComponent> selection;
        if (screenView != null && (selection = screenView.getSelectionModel().getSelection()).size() == 1) {
            NlComponent selected;
            for (selected = selection.get(0); selected != null && !selected.isRoot() && selected.getChildren().isEmpty(); selected = selected.getParent()) {
            }
            return selected;
        }
        return null;
    }

    public void actionPerformed(AnActionEvent e) {
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        if (screenView == null) {
            return;
        }
        NlComponent target = ConvertToConstraintLayoutAction.findTarget(screenView);
        if (target == null) {
            return;
        }
        Project project = this.mySurface.getProject();
        ConvertToConstraintLayoutForm dialog = new ConvertToConstraintLayoutForm(project);
        if (!dialog.showAndGet()) {
            return;
        }
        boolean flatten = dialog.getFlattenHierarchy();
        boolean includeIds = dialog.getFlattenReferenced();
        GradleDependencyManager manager = GradleDependencyManager.getInstance(project);
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)"com.android.support.constraint:constraint-layout:+");
        if (!manager.ensureLibraryIsIncluded(screenView.getModel().getModule(), Collections.singletonList(coordinate), null)) {
            return;
        }
        NlModel model = screenView.getModel();
        ConstraintLayoutConverter converter = new ConstraintLayoutConverter(screenView, target, flatten, includeIds);
        converter.execute();
        ConvertToConstraintLayoutAction.inferConstraints(model);
    }

    private static void inferConstraints(final NlModel model) {
        RenderResult result = model.getRenderResult();
        if (result == null || !result.getRenderResult().isSuccess()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            final ConstraintModel constraintModel = ConstraintModel.getConstraintModel(model);
            if (constraintModel != null) {
                int dpi = model.getConfiguration().getDensity().getDpiValue();
                constraintModel.setDpiValue(dpi);
                constraintModel.updateNlModel(null, model.getComponents(), true);
                WidgetsScene scene = constraintModel.getScene();
                try {
                    Scout.inferConstraints((WidgetsScene)scene);
                }
                catch (Throwable t) {
                    Logger.getInstance(ConvertToConstraintLayoutAction.class).warn(t);
                }
                WriteCommandAction.runWriteCommandAction((Project)model.getProject(), (String)"Infer Constraints", null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        constraintModel.saveToXML(true);
                        constraintModel.setNeedsAnimateConstraints(1);
                        List<NlComponent> components = model.getComponents();
                        for (NlComponent root : components) {
                            ConvertToConstraintLayoutAction.removeAbsolutePositionAndSizes(root);
                        }
                    }
                }, (PsiFile[])new PsiFile[]{model.getFile()});
            }
        }, ModalityState.any());
    }

    private static void removeAbsolutePositionAndSizes(NlComponent component) {
        for (NlComponent child : component.getChildren()) {
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_ABSOLUTE_X, null);
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_ABSOLUTE_Y, null);
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_ABSOLUTE_WIDTH, null);
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_ABSOLUTE_HEIGHT, null);
            ConvertToConstraintLayoutAction.removeAbsolutePositionAndSizes(child);
        }
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/actions/ConvertToConstraintLayoutAction", "modelChanged"));
        }
        model.removeListener(this);
        ConvertToConstraintLayoutAction.inferConstraints(model);
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/actions/ConvertToConstraintLayoutAction", "modelRendered"));
        }
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/actions/ConvertToConstraintLayoutAction", "modelChangedOnLayout"));
        }
    }

    private static class ConstraintLayoutConverter
    extends WriteCommandAction {
        private final ScreenView myScreenView;
        private final boolean myFlatten;
        private final boolean myIncludeIds;
        private ViewEditorImpl myEditor;
        private List<NlComponent> myToBeFlattened;
        private final NlComponent myRoot;
        private final NlComponent myLayout;

        public ConstraintLayoutConverter(@NotNull ScreenView screenView, @NotNull NlComponent target, boolean flatten, boolean includeIds) {
            if (screenView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/actions/ConvertToConstraintLayoutAction$ConstraintLayoutConverter", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/uibuilder/actions/ConvertToConstraintLayoutAction$ConstraintLayoutConverter", "<init>"));
            }
            super(screenView.getSurface().getProject(), ConvertToConstraintLayoutAction.TITLE, new PsiFile[]{screenView.getModel().getFile()});
            this.myScreenView = screenView;
            this.myFlatten = flatten;
            this.myIncludeIds = includeIds;
            this.myLayout = target;
            this.myRoot = this.myScreenView.getModel().getComponents().get(0);
            this.myEditor = new ViewEditorImpl(this.myScreenView);
        }

        protected void run(@NotNull Result result) throws Throwable {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/actions/ConvertToConstraintLayoutAction$ConstraintLayoutConverter", "run"));
            }
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (this.myLayout == null) {
                return;
            }
            this.myToBeFlattened = Lists.newArrayList();
            this.processComponent(this.myLayout);
            this.myLayout.setAttribute("http://schemas.android.com/apk/res/android", "padding", null);
            this.myLayout.setAttribute("http://schemas.android.com/apk/res/android", "paddingLeft", null);
            this.myLayout.setAttribute("http://schemas.android.com/apk/res/android", "paddingRight", null);
            this.myLayout.setAttribute("http://schemas.android.com/apk/res/android", "paddingStart", null);
            this.myLayout.setAttribute("http://schemas.android.com/apk/res/android", "paddingEnd", null);
            this.myLayout.setAttribute("http://schemas.android.com/apk/res/android", "paddingTop", null);
            this.myLayout.setAttribute("http://schemas.android.com/apk/res/android", "paddingBottom", null);
            this.flatten();
            PsiElement tag = this.myLayout.getTag().setName("android.support.constraint.ConstraintLayout");
            CodeStyleManager.getInstance((Project)this.getProject()).reformat(tag);
        }

        private void processComponent(NlComponent component) {
            for (NlComponent child : component.getChildren()) {
                int dpx = this.myEditor.pxToDp(child.x - this.myRoot.x);
                int dpy = this.myEditor.pxToDp(child.y - this.myRoot.y);
                int dpw = this.myEditor.pxToDp(child.w);
                int dph = this.myEditor.pxToDp(child.h);
                child.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_ABSOLUTE_X, String.format(Locale.ROOT, "%ddp", dpx));
                child.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_ABSOLUTE_Y, String.format(Locale.ROOT, "%ddp", dpy));
                child.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_ABSOLUTE_WIDTH, String.format(Locale.ROOT, "%ddp", dpw));
                child.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_ABSOLUTE_HEIGHT, String.format(Locale.ROOT, "%ddp", dph));
                List toDelete = null;
                for (AttributeSnapshot attribute : child.getAttributes()) {
                    String name = attribute.name;
                    if (!name.startsWith("layout_") || !"http://schemas.android.com/apk/res/android".equals(attribute.namespace) || name.equals("layout_width") || name.equals("layout_height")) continue;
                    if (toDelete == null) {
                        toDelete = Lists.newArrayList();
                    }
                    toDelete.add(name);
                }
                if (toDelete != null) {
                    for (String name : toDelete) {
                        child.setAttribute("http://schemas.android.com/apk/res/android", name, null);
                    }
                }
                if (ConstraintLayoutConverter.isLayout(child)) {
                    if (!this.myFlatten || !this.shouldFlatten(child)) continue;
                    this.myToBeFlattened.add(child);
                }
                this.processComponent(child);
            }
        }

        private void flatten() {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
            Document document = documentManager.getDocument((PsiFile)this.myScreenView.getModel().getFile());
            if (document == null) {
                return;
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            ArrayList ranges = Lists.newArrayList();
            for (NlComponent component : this.myToBeFlattened) {
                XmlTag tag = component.getTag();
                PsiElement openStart = null;
                PsiElement openEnd = null;
                PsiElement closeStart = null;
                PsiElement closeEnd = null;
                for (PsiElement curr = tag.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
                    IElementType elementType = curr.getNode().getElementType();
                    if (elementType == XmlTokenType.XML_START_TAG_START) {
                        openStart = curr;
                        continue;
                    }
                    if (elementType == XmlTokenType.XML_TAG_END) {
                        if (closeStart == null) {
                            openEnd = curr;
                            continue;
                        }
                        closeEnd = curr;
                        break;
                    }
                    if (elementType == XmlTokenType.XML_END_TAG_START) {
                        closeStart = curr;
                        continue;
                    }
                    if (elementType != XmlTokenType.XML_EMPTY_ELEMENT_END) continue;
                    openEnd = curr;
                    break;
                }
                if (openStart == null || openEnd == null || closeStart == null || closeEnd == null) continue;
                ranges.add(new TextRange(openStart.getTextOffset(), openEnd.getTextOffset() + openEnd.getTextLength()));
                ranges.add(new TextRange(closeStart.getTextOffset(), closeEnd.getTextOffset() + closeEnd.getTextLength()));
            }
            ranges.sort(new Comparator<TextRange>(){

                @Override
                public int compare(TextRange o1, TextRange o2) {
                    return o2.getStartOffset() - o1.getStartOffset();
                }
            });
            for (TextRange range : ranges) {
                document.deleteString(range.getStartOffset(), range.getEndOffset());
            }
            documentManager.commitDocument(document);
        }

        private static boolean isLayout(@NotNull NlComponent component) {
            Object viewObject;
            NlComponent child;
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/actions/ConvertToConstraintLayoutAction$ConstraintLayoutConverter", "isLayout"));
            }
            List<NlComponent> children = component.getChildren();
            if (children.size() > 1) {
                return true;
            }
            if (children.size() == 1 && !"requestFocus".equals((child = children.get(0)).getTagName())) {
                return true;
            }
            if (component.viewInfo != null && (viewObject = component.viewInfo.getViewObject()) != null) {
                for (Class<?> cls = viewObject.getClass(); cls != null; cls = cls.getSuperclass()) {
                    String fqcn = cls.getName();
                    if ("android.widget.AdapterView".equals(fqcn)) {
                        return false;
                    }
                    if (fqcn.startsWith("android.webkit.") && fqcn.endsWith("WebView")) {
                        return false;
                    }
                    if (!"android.view.ViewGroup".equals(fqcn)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean shouldFlatten(@NotNull NlComponent component) {
            XmlAttributeValue valueElement;
            XmlAttribute attribute;
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/actions/ConvertToConstraintLayoutAction$ConstraintLayoutConverter", "shouldFlatten"));
            }
            if (component.getAttribute("http://schemas.android.com/apk/res/android", "background") != null || component.getAttribute("http://schemas.android.com/apk/res/android", "foreground") != null || component.getAttribute(null, "id") != null) {
                return false;
            }
            String id = component.getAttribute("http://schemas.android.com/apk/res/android", "id");
            if (id == null) {
                return true;
            }
            if (!this.myIncludeIds && (attribute = component.getTag().getAttribute("id", "http://schemas.android.com/apk/res/android")) != null && (valueElement = attribute.getValueElement()) != null && valueElement.isValid()) {
                UsageInfo[] usages;
                RenameProcessor processor = new RenameProcessor(this.myScreenView.getSurface().getProject(), (PsiElement)valueElement, "NONEXISTENT_ID12345", false, false);
                processor.setPreviewUsages(false);
                XmlFile layoutFile = this.myScreenView.getModel().getFile();
                for (UsageInfo info : usages = processor.findUsages()) {
                    PsiFile file = info.getFile();
                    if (layoutFile.equals(file)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

