/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ColorExtractor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.DBSCANColorExtractor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ExtractedColor;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.ViewAndColorForm;
import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SimpleViewCreator
extends WidgetCreator {
    private final Rectangle mySelectionBounds;
    Rectangle myAndroidBounds;

    public SimpleViewCreator(@NotNull Mockup mockup, @NotNull NlModel model, @NotNull ScreenView screenView, @NotNull Rectangle selection) {
        if (mockup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mockup", "com/android/tools/idea/uibuilder/mockup/editor/creators/SimpleViewCreator", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/editor/creators/SimpleViewCreator", "<init>"));
        }
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/mockup/editor/creators/SimpleViewCreator", "<init>"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/android/tools/idea/uibuilder/mockup/editor/creators/SimpleViewCreator", "<init>"));
        }
        super(mockup, model, screenView);
        this.myAndroidBounds = new Rectangle();
        this.mySelectionBounds = selection;
        Rectangle cropping = this.getMockup().getComputedCropping();
        NlComponent component = this.getMockup().getComponent();
        float xScale = (float)component.w / (float)cropping.width;
        float yScale = (float)component.h / (float)cropping.height;
        this.myAndroidBounds.setBounds(Math.round(xScale * (float)this.mySelectionBounds.x), Math.round(yScale * (float)this.mySelectionBounds.y), Math.round(xScale * (float)this.mySelectionBounds.width), Math.round(yScale * (float)this.mySelectionBounds.height));
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        if ("View" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/mockup/editor/creators/SimpleViewCreator", "getAndroidViewTag"));
        }
        return "View";
    }

    protected void extractColor(@NotNull BufferedImage image, @NotNull ColorExtractor.ColorExtractorCallback callback) {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/uibuilder/mockup/editor/creators/SimpleViewCreator", "extractColor"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/uibuilder/mockup/editor/creators/SimpleViewCreator", "extractColor"));
        }
        Rectangle realCropping = this.getMockup().getComputedCropping();
        Rectangle selectionBounds = this.getSelectionBounds();
        BufferedImage subimage = image.getSubimage(realCropping.x + selectionBounds.x, realCropping.y + selectionBounds.y, selectionBounds.width, selectionBounds.height);
        DBSCANColorExtractor colorExtractor = new DBSCANColorExtractor(subimage, 1.3f, DBSCANColorExtractor.getMinClusterSize(subimage));
        ((ColorExtractor)colorExtractor).run(callback);
    }

    protected void extractColor(final ViewAndColorForm viewAndColorForm, BufferedImage image) {
        this.extractColor(image, new ColorExtractor.ColorExtractorCallback(){

            @Override
            public void result(Collection<ExtractedColor> rgbColors) {
                viewAndColorForm.addColors(rgbColors);
            }

            @Override
            public void progress(int progress) {
                viewAndColorForm.setProgress(progress);
            }
        });
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/mockup/editor/creators/SimpleViewCreator", "addAttributes"));
        }
        this.addLayoutEditorPositionAttribute(transaction, this.myAndroidBounds);
        this.addSizeAttributes(transaction, this.myAndroidBounds);
        this.addMockupAttributes(transaction, this.mySelectionBounds);
    }

    public Rectangle getAndroidBounds() {
        return this.myAndroidBounds;
    }

    public Rectangle getSelectionBounds() {
        return this.mySelectionBounds;
    }
}

