/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.google.common.base.Charsets;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.EnumMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;

public class NlPaletteModel {
    public static final String ANDROID_PALETTE = "android-palette";
    public static final String PALETTE_VERSION = "v1";
    private final Map<NlLayoutType, Palette> myTypeToPalette;
    private final Project myProject;

    public static NlPaletteModel get(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/palette/NlPaletteModel", "get"));
        }
        return (NlPaletteModel)project.getComponent(NlPaletteModel.class);
    }

    private NlPaletteModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/palette/NlPaletteModel", "<init>"));
        }
        this.myTypeToPalette = new EnumMap<NlLayoutType, Palette>(NlLayoutType.class);
        this.myProject = project;
    }

    @NotNull
    Palette getPalette(@NotNull NlLayoutType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/palette/NlPaletteModel", "getPalette"));
        }
        assert (type.isSupportedByDesigner());
        Palette palette = this.myTypeToPalette.get((Object)type);
        if (palette == null) {
            this.loadPalette(type);
            Palette palette2 = this.myTypeToPalette.get((Object)type);
            if (palette2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPaletteModel", "getPalette"));
            }
            return palette2;
        }
        Palette palette3 = palette;
        if (palette3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPaletteModel", "getPalette"));
        }
        return palette3;
    }

    private void loadPalette(@NotNull NlLayoutType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/palette/NlPaletteModel", "loadPalette"));
        }
        try {
            String metadata = type.getPaletteFileName();
            URL url = NlPaletteModel.class.getResource(metadata);
            URLConnection connection = url.openConnection();
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream(), Charsets.UTF_8);){
                this.loadPalette(reader, type);
            }
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    void loadPalette(@NotNull Reader reader, @NotNull NlLayoutType type) throws JAXBException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/android/tools/idea/uibuilder/palette/NlPaletteModel", "loadPalette"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/palette/NlPaletteModel", "loadPalette"));
        }
        Palette palette = Palette.parse(reader, ViewHandlerManager.get(this.myProject));
        this.myTypeToPalette.put(type, palette);
    }
}

