/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.adtui.splitter.ComponentsSplitter;
import com.android.tools.adtui.splitter.SplitterUtil;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.IconPreviewFactory;
import com.android.tools.idea.uibuilder.palette.NlPaletteModel;
import com.android.tools.idea.uibuilder.palette.NlPaletteTreeGrid;
import com.android.tools.idea.uibuilder.palette.NlPreviewImagePanel;
import com.android.tools.idea.uibuilder.palette.NlPreviewPanel;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette.PaletteMode;
import com.android.tools.idea.uibuilder.palette.TogglePaletteModeAction;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPalettePanel
extends JPanel
implements Disposable,
DataProvider,
ToolContent<DesignSurface> {
    private final Project myProject;
    private final NlPreviewPanel myPreviewPane;
    private final CopyProvider myCopyProvider;
    private final NlPaletteTreeGrid myPalettePanel;
    private final DependencyManager myDependencyManager;
    private final CopyPasteManager myCopyPasteManager;
    private NlLayoutType myLayoutType;
    private Runnable myCloseAutoHideCallback;

    public NlPalettePanel(@NotNull Project project, @Nullable DesignSurface designSurface) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/palette/NlPalettePanel", "<init>"));
        }
        this(project, designSurface, CopyPasteManager.getInstance());
    }

    NlPalettePanel(@NotNull Project project, @Nullable DesignSurface designSurface, @NotNull CopyPasteManager copyPasteManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/palette/NlPalettePanel", "<init>"));
        }
        if (copyPasteManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyPasteManager", "com/android/tools/idea/uibuilder/palette/NlPalettePanel", "<init>"));
        }
        this.myProject = project;
        this.myCopyPasteManager = copyPasteManager;
        IconPreviewFactory iconPreviewFactory = new IconPreviewFactory();
        Disposer.register((Disposable)this, (Disposable)iconPreviewFactory);
        this.myDependencyManager = new DependencyManager(project, this, this);
        this.myPalettePanel = new NlPaletteTreeGrid(project, this.myDependencyManager, this::closeAutoHideToolWindow, designSurface, iconPreviewFactory);
        this.myPreviewPane = new NlPreviewPanel(new NlPreviewImagePanel(iconPreviewFactory, this.myDependencyManager, this::closeAutoHideToolWindow));
        this.myCopyProvider = new CopyProviderImpl();
        this.myPalettePanel.setSelectionListener(this.myPreviewPane);
        this.myLayoutType = NlLayoutType.UNKNOWN;
        ComponentsSplitter splitter = new ComponentsSplitter(true, true);
        splitter.setInnerComponent((JComponent)this.myPalettePanel);
        splitter.setLastComponent((JComponent)this.myPreviewPane);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setLastSize(JBUI.scale((int)140));
        SplitterUtil.setMinimumHeight((JComponent)this.myPalettePanel, (int)20);
        SplitterUtil.setMinimumHeight((JComponent)this.myPreviewPane, (int)40);
        Disposer.register((Disposable)this, (Disposable)splitter);
        Disposer.register((Disposable)this, (Disposable)this.myPalettePanel);
        Disposer.register((Disposable)this, (Disposable)this.myPreviewPane);
        this.setLayout(new BorderLayout());
        this.add((Component)splitter, "Center");
        this.setToolContext(designSurface);
    }

    @NotNull
    public JComponent getComponent() {
        NlPalettePanel nlPalettePanel = this;
        if (nlPalettePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPalettePanel", "getComponent"));
        }
        return nlPalettePanel;
    }

    @NotNull
    public JComponent getFocusedComponent() {
        NlPaletteTreeGrid nlPaletteTreeGrid = this.myPalettePanel;
        if (nlPaletteTreeGrid == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPalettePanel", "getFocusedComponent"));
        }
        return nlPaletteTreeGrid;
    }

    @Override
    public void requestFocus() {
        this.myPalettePanel.requestFocus();
    }

    @NotNull
    public NlPaletteTreeGrid getTreeGrid() {
        NlPaletteTreeGrid nlPaletteTreeGrid = this.myPalettePanel;
        if (nlPaletteTreeGrid == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPalettePanel", "getTreeGrid"));
        }
        return nlPaletteTreeGrid;
    }

    @NotNull
    public List<AnAction> getGearActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>(3);
        actions.add((AnAction)new TogglePaletteModeAction(this, PaletteMode.ICON_AND_NAME));
        actions.add((AnAction)new TogglePaletteModeAction(this, PaletteMode.LARGE_ICONS));
        actions.add((AnAction)new TogglePaletteModeAction(this, PaletteMode.SMALL_ICONS));
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPalettePanel", "getGearActions"));
        }
        return arrayList;
    }

    @NotNull
    public List<AnAction> getAdditionalActions() {
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPalettePanel", "getAdditionalActions"));
        }
        return list;
    }

    public void registerCloseAutoHideWindow(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/uibuilder/palette/NlPalettePanel", "registerCloseAutoHideWindow"));
        }
        this.myCloseAutoHideCallback = runnable;
    }

    public boolean supportsFiltering() {
        return true;
    }

    public void setFilter(@NotNull String filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/uibuilder/palette/NlPalettePanel", "setFilter"));
        }
        this.myPalettePanel.setFilter(filter);
    }

    public void setToolContext(@Nullable DesignSurface designSurface) {
        this.myPreviewPane.setDesignSurface(designSurface);
        Module module = NlPalettePanel.getModule(designSurface);
        if (designSurface != null && module != null && this.myLayoutType != designSurface.getLayoutType()) {
            this.myLayoutType = designSurface.getLayoutType();
            NlPaletteModel model = NlPaletteModel.get(this.myProject);
            Palette palette = model.getPalette(this.myLayoutType);
            this.myPalettePanel.populateUiModel(palette, designSurface);
            this.myDependencyManager.setPalette(palette, module);
            this.repaint();
        }
    }

    private void closeAutoHideToolWindow() {
        if (this.myCloseAutoHideCallback != null) {
            this.myCloseAutoHideCallback.run();
        }
    }

    @Nullable
    private static Module getModule(@Nullable DesignSurface designSurface) {
        Configuration configuration = designSurface != null && designSurface.getLayoutType().isSupportedByDesigner() ? designSurface.getConfiguration() : null;
        return configuration != null ? configuration.getModule() : null;
    }

    @NotNull
    public PaletteMode getMode() {
        PaletteMode paletteMode = this.myPalettePanel.getMode();
        if (paletteMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPalettePanel", "getMode"));
        }
        return paletteMode;
    }

    public void setMode(@NotNull PaletteMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/uibuilder/palette/NlPalettePanel", "setMode"));
        }
        this.myPalettePanel.setMode(mode);
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return PlatformDataKeys.COPY_PROVIDER.is(dataId) ? this.myCopyProvider : null;
    }

    private class CopyProviderImpl
    implements CopyProvider {
        private CopyProviderImpl() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlPalettePanel$CopyProviderImpl", "performCopy"));
            }
            Palette.Item item = NlPalettePanel.this.myPalettePanel.getSelectedItem();
            if (item != null && !NlPalettePanel.this.myDependencyManager.needsLibraryLoad(item)) {
                DnDTransferComponent component = new DnDTransferComponent(item.getTagName(), item.getXml(), 0, 0);
                NlPalettePanel.this.myCopyPasteManager.setContents((Transferable)new ItemTransferable(new DnDTransferItem(component)));
            }
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlPalettePanel$CopyProviderImpl", "isCopyEnabled"));
            }
            Palette.Item item = NlPalettePanel.this.myPalettePanel.getSelectedItem();
            return item != null && !NlPalettePanel.this.myDependencyManager.needsLibraryLoad(item);
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/palette/NlPalettePanel$CopyProviderImpl", "isCopyVisible"));
            }
            return true;
        }
    }
}

