/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.scene.Scene;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.decorator.SceneDecorator;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawConnection;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConstraintLayoutDecorator
extends SceneDecorator {
    static final String[] LEFT_DIR = new String[]{"layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"};
    static final String[] RIGHT_DIR = new String[]{"layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf"};
    static final String[] TOP_DIR = new String[]{"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"};
    static final String[] BOTTOM_DIR = new String[]{"layout_constraintBottom_toBottomOf", "layout_constraintBottom_toTopOf"};
    static final String[][] ourConnections = new String[][]{LEFT_DIR, RIGHT_DIR, TOP_DIR, BOTTOM_DIR};
    static final String BASELINE = "BASELINE";
    static final String[] BASELINE_DIR = new String[]{"layout_constraintBaseline_toBaselineOf"};
    static final String BASELINE_TYPE = "BASELINE_TYPE";
    static final String[] MARGIN_ATTR = new String[]{"layout_marginLeft", "layout_marginRight", "layout_marginTop", "layout_marginBottom"};
    static final String[] BIAS_ATTR = new String[]{"layout_constraintHorizontal_bias", "layout_constraintHorizontal_bias", "layout_constraintVertical_bias", "layout_constraintVertical_bias"};
    static final boolean[] FLIP_BIAS = new boolean[]{true, false, false, true};
    static final ConnectionType[] DIR_TABLE = new ConnectionType[]{ConnectionType.SAME, ConnectionType.BACKWARD};
    static final String[] ourDirections = new String[]{"LEFT", "RIGHT", "TOP", "BOTTOM"};
    static final String[] ourChainDirections = new String[]{"CHAIN_LEFT", "CHAIN_RIGHT", "CHAIN_TOP", "CHAIN_BOTTOM"};
    static final String[] ourDirectionsType = new String[]{"LEFT_TYPE", "RIGHT_TYPE", "TOP_TYPE", "BOTTOM_TYPE"};
    static final int[] ourOppositeDirection = new int[]{1, 0, 3, 2};

    private void convert(@NotNull SceneContext sceneContext, Rectangle rect) {
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/ConstraintLayoutDecorator", "convert"));
        }
        rect.x = sceneContext.getSwingX(rect.x);
        rect.y = sceneContext.getSwingY(rect.y);
        rect.width = sceneContext.getSwingDimension(rect.width);
        rect.height = sceneContext.getSwingDimension(rect.height);
    }

    private void gatherProperties(@NotNull SceneComponent component, @NotNull SceneComponent child) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/ConstraintLayoutDecorator", "gatherProperties"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/android/tools/idea/uibuilder/scene/decorator/ConstraintLayoutDecorator", "gatherProperties"));
        }
        for (int i = 0; i < ourDirections.length; ++i) {
            this.getConnection(component, child, ourConnections[i], ourDirections[i], ourDirectionsType[i]);
        }
        this.getConnection(component, child, BASELINE_DIR, BASELINE, BASELINE_TYPE);
    }

    private void getConnection(SceneComponent component, SceneComponent child, String[] atributes, String dir, String dirType) {
        String id = null;
        ConnectionType type = ConnectionType.SAME;
        for (int i = 0; i < atributes.length; ++i) {
            id = child.getNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", atributes[i]);
            type = DIR_TABLE[i];
            if (id != null) break;
        }
        if (id == null) {
            child.myCache.put(dir, id);
            child.myCache.put(dirType, (Object)ConnectionType.SAME);
            return;
        }
        if (id.equalsIgnoreCase("parent")) {
            child.myCache.put(dir, component);
            child.myCache.put(dirType, (Object)type);
            return;
        }
        String cleanId = NlComponent.extractId(id);
        if (cleanId == null) {
            child.myCache.put(dir, id);
            child.myCache.put(dirType, (Object)ConnectionType.SAME);
            return;
        }
        if (cleanId.equals(component.getId())) {
            child.myCache.put(dir, component);
            child.myCache.put(dirType, (Object)type);
            return;
        }
        for (SceneComponent con : component.getChildren()) {
            if (!cleanId.equals(con.getId())) continue;
            child.myCache.put(dir, con);
            child.myCache.put(dirType, (Object)type);
            return;
        }
        child.myCache.put(dirType, (Object)ConnectionType.SAME);
    }

    @Override
    protected void addBackground(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/decorator/ConstraintLayoutDecorator", "addBackground"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/ConstraintLayoutDecorator", "addBackground"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/ConstraintLayoutDecorator", "addBackground"));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildListChildren(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        void component;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/decorator/ConstraintLayoutDecorator", "buildListChildren"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/ConstraintLayoutDecorator", "buildListChildren"));
        }
        if (sceneComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/ConstraintLayoutDecorator", "buildListChildren"));
        }
        ArrayList<SceneComponent> children = component.getChildren();
        if (children.size() > 0) {
            for (SceneComponent child : component.getChildren()) {
                this.gatherProperties((SceneComponent)component, child);
            }
            Rectangle rect = new Rectangle();
            component.fillRect(rect);
            DisplayList.UNClip unClip = list.addClip(sceneContext, rect);
            Scene scene = component.getScene();
            boolean showAllConstraints = scene.isShowAllConstraints();
            List<NlComponent> selection = scene.getSelection();
            for (SceneComponent child : children) {
                child.buildDisplayList(time, list, sceneContext);
                if (!showAllConstraints && !selection.contains(child.getNlComponent())) continue;
                this.buildListConnections(list, time, sceneContext, (SceneComponent)component, child);
            }
            list.add(unClip);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void buildListConnections(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent component, @NotNull SceneComponent sceneComponent) {
        int i;
        void child;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/decorator/ConstraintLayoutDecorator", "buildListConnections"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/ConstraintLayoutDecorator", "buildListConnections"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/ConstraintLayoutDecorator", "buildListConnections"));
        }
        if (sceneComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/android/tools/idea/uibuilder/scene/decorator/ConstraintLayoutDecorator", "buildListConnections"));
        }
        Rectangle dest_rect = new Rectangle();
        Rectangle source_rect = new Rectangle();
        child.fillDrawRect(time, source_rect);
        this.convert(sceneContext, source_rect);
        int x = source_rect.x;
        int y = source_rect.y;
        int w = source_rect.width;
        int h = source_rect.height;
        ConnectionType[] connectionTypes = new ConnectionType[ourDirections.length];
        SceneComponent[] connectionTo = new SceneComponent[ourDirections.length];
        for (i = 0; i < ourDirections.length; ++i) {
            connectionTypes[i] = (ConnectionType)((Object)child.myCache.get(ourDirectionsType[i]));
            connectionTo[i] = (SceneComponent)child.myCache.get(ourDirections[i]);
        }
        for (i = 0; i < ourDirections.length; ++i) {
            boolean shift;
            String biasString;
            int connect;
            ConnectionType type = connectionTypes[i];
            SceneComponent sc = connectionTo[i];
            int destType = 0;
            if (sc == null) continue;
            sc.fillDrawRect(time, dest_rect);
            this.convert(sceneContext, dest_rect);
            int n = connect = type == ConnectionType.SAME ? i : ourOppositeDirection[i];
            if (child.getParent().equals(sc)) {
                destType = 1;
            } else if ("android.support.constraint.Guideline".equalsIgnoreCase(sc.getComponentClassName())) {
                destType = 2;
            }
            int connectType = 1;
            if (connectionTo[ourOppositeDirection[i]] != null) {
                connectType = 2;
                if (connectionTo[ourOppositeDirection[i]] == sc && destType != 1) {
                    connectType = 4;
                }
            }
            SceneComponent toComponentsTo = (SceneComponent)sc.myCache.get(ourDirections[connect]);
            if (type == ConnectionType.BACKWARD && toComponentsTo == child && sc.myCache.get(ourDirectionsType[connect]) == ConnectionType.BACKWARD) {
                connectType = 3;
                if (sc.myCache.containsKey(ourChainDirections[ourOppositeDirection[i]])) continue;
                child.myCache.put(ourChainDirections[i], "drawn");
            }
            int margin = 0;
            int marginDistance = 0;
            boolean isMarginReference = false;
            float bias = 0.5f;
            String marginString = child.getNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", MARGIN_ATTR[i]);
            if (marginString == null) {
                if (i == 0) {
                    marginString = child.getNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart");
                } else if (i == 1) {
                    marginString = child.getNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd");
                }
            }
            if (marginString != null) {
                if (marginString.startsWith("@")) {
                    isMarginReference = true;
                }
                margin = ConstraintUtilities.getDpValue(child.getNlComponent(), marginString);
                marginDistance = sceneContext.getSwingDimension(margin);
            }
            if ((biasString = child.getNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", BIAS_ATTR[i])) != null) {
                try {
                    bias = Float.parseFloat(biasString);
                    if (FLIP_BIAS[i]) {
                        bias = 1.0f - bias;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean bl = shift = toComponentsTo != null;
            if (destType == 2) {
                connect = ourOppositeDirection[i];
            }
            DrawConnection.buildDisplayList(list, connectType, source_rect, i, dest_rect, connect, destType, shift, margin, marginDistance, isMarginReference, Float.valueOf(bias));
        }
        SceneComponent baseLineConnection = (SceneComponent)child.myCache.get(BASELINE);
        if (baseLineConnection != null) {
            baseLineConnection.fillDrawRect(time, dest_rect);
            this.convert(sceneContext, dest_rect);
            int dest_offset = sceneContext.getSwingDimension(baseLineConnection.getBaseline());
            int source_offset = sceneContext.getSwingDimension(child.getBaseline());
            source_rect.y += source_offset;
            source_rect.height = 0;
            dest_rect.y += dest_offset;
            dest_rect.height = 0;
            DrawConnection.buildDisplayList(list, 5, source_rect, 5, dest_rect, 5, 0, false, 0, 0, false, Float.valueOf(0.0f));
        }
    }

    static enum ConnectionType {
        SAME,
        BACKWARD;

    }
}

