/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DrawRegion;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class DrawTextRegion
extends DrawRegion {
    static boolean DO_WRAP = false;
    protected int myBaseLineOffset = 0;
    protected int mHorizontalPadding = 0;
    protected int mVerticalPadding = 0;
    protected int mVerticalMargin = 0;
    protected int mHorizontalMargin = 0;
    protected boolean mToUpperCase = false;
    public static final int TEXT_ALIGNMENT_VIEW_START = 5;
    public static final int TEXT_ALIGNMENT_VIEW_END = 6;
    public static final int TEXT_ALIGNMENT_CENTER = 4;
    protected int mAlignmentX = 5;
    protected int mAlignmentY = 5;
    protected String mText;
    protected Font mFont = new Font("Helvetica", 0, 22);
    protected boolean mSingleLine = false;
    JTextPane mTextPane = new JTextPane();

    public static void setDoWrap(boolean doWrap) {
        DO_WRAP = doWrap;
    }

    public DrawTextRegion(String string) {
        this.mTextPane.setBackground(new Color(0, 0, 0, 0));
        String[] sp = string.split(",");
        int c = super.parse(sp, 0);
        this.myBaseLineOffset = Integer.parseInt(sp[c++]);
        this.mSingleLine = Boolean.parseBoolean(sp[c++]);
        this.mToUpperCase = Boolean.parseBoolean(sp[c++]);
        this.mAlignmentX = Integer.parseInt(sp[c++]);
        this.mAlignmentY = Integer.parseInt(sp[c++]);
        this.mText = string.substring(string.indexOf(34) + 1, string.lastIndexOf(34));
    }

    @Override
    public String serialize() {
        return this.getClass().getSimpleName() + "," + this.x + "," + this.y + "," + this.width + "," + this.height + "," + this.myBaseLineOffset + "," + this.mSingleLine + "," + this.mToUpperCase + "," + this.mAlignmentX + "," + this.mAlignmentY + ",\"" + this.mText + "\"";
    }

    public DrawTextRegion() {
        this.mTextPane.setBackground(new Color(0, 0, 0, 0));
    }

    public DrawTextRegion(int x, int y, int width, int height, int baseLineOffset, String text) {
        super(x, y, width, height);
        this.mTextPane.setBackground(new Color(0, 0, 0, 0));
        this.myBaseLineOffset = baseLineOffset;
        this.mText = text;
    }

    public DrawTextRegion(int x, int y, int width, int height, int baseLineOffset, String text, boolean singleLine, boolean toUpperCase, int textAlignmentX, int textAlignmentY, int fontSize) {
        super(x, y, width, height);
        this.mTextPane.setBackground(new Color(0, 0, 0, 0));
        this.mText = text;
        this.myBaseLineOffset = baseLineOffset;
        this.mSingleLine = singleLine;
        this.mToUpperCase = toUpperCase;
        this.mAlignmentX = textAlignmentX;
        this.mAlignmentY = textAlignmentY;
        this.mFont = new Font("Helvetica", 0, (int)((double)fontSize / 2.3));
    }

    public static int androidToSwingFontSize(float fontSize) {
        return Math.round((fontSize * 2.0f + 4.5f) / 2.41f);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        int tx = this.x;
        int ty = this.y;
        int h = this.height;
        int w = this.width;
        if (!sceneContext.getColorSet().drawBackground()) {
            return;
        }
        super.paint(g, sceneContext);
        ColorSet colorSet = sceneContext.getColorSet();
        int horizontalPadding = this.mHorizontalPadding + this.mHorizontalMargin;
        int verticalPadding = this.mVerticalPadding + this.mVerticalMargin;
        g.setFont(this.mFont);
        FontMetrics fontMetrics = g.getFontMetrics();
        Color color = colorSet.getFrames();
        g.setColor(color);
        String string = this.mText;
        if (this.mToUpperCase) {
            string = string.toUpperCase();
        }
        int ftx = 0;
        int fty = 0;
        int stringWidth = fontMetrics.stringWidth(string);
        if (stringWidth > w && !this.mSingleLine) {
            this.mTextPane.setText(string);
            this.mTextPane.setForeground(color);
            this.mTextPane.setSize(w, h);
            this.mTextPane.setFont(this.mFont.deriveFont((float)this.mFont.getSize() * 0.88f));
            StyledDocument doc = this.mTextPane.getStyledDocument();
            SimpleAttributeSet attributeSet = new SimpleAttributeSet();
            switch (this.mAlignmentX) {
                case 5: {
                    StyleConstants.setAlignment(attributeSet, 0);
                    break;
                }
                case 4: {
                    StyleConstants.setAlignment(attributeSet, 1);
                    break;
                }
                case 6: {
                    StyleConstants.setAlignment(attributeSet, 2);
                }
            }
            switch (this.mAlignmentY) {
                case 5: {
                    this.mTextPane.setAlignmentY(0.0f);
                    break;
                }
                case 4: {
                    this.mTextPane.setAlignmentY(0.5f);
                    break;
                }
                case 6: {
                    this.mTextPane.setAlignmentY(1.0f);
                }
            }
            doc.setParagraphAttributes(0, doc.getLength(), attributeSet, false);
            g.translate(tx, ty);
            Shape clip = g.getClip();
            g.clipRect(0, 0, w, h);
            this.mTextPane.paint(g);
            g.setClip(clip);
            g.translate(-tx, -ty);
        } else {
            switch (this.mAlignmentX) {
                case 5: {
                    ftx = tx + horizontalPadding;
                    break;
                }
                case 4: {
                    int paddx = (w - stringWidth) / 2;
                    ftx = tx + paddx;
                    break;
                }
                case 6: {
                    int padd = w - stringWidth + horizontalPadding;
                    ftx = tx + padd;
                }
            }
            fty = this.myBaseLineOffset + ty;
            Shape clip = g.getClip();
            g.clipRect(tx, ty, w, h);
            g.drawString(string, ftx, fty);
            g.setClip(clip);
        }
    }
}

