/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.ScenePicker;
import com.android.tools.idea.uibuilder.scene.target.Target;
import org.jetbrains.annotations.NotNull;

public abstract class BaseTarget
implements Target {
    protected SceneComponent myComponent;
    protected float myLeft = 0.0f;
    protected float myTop = 0.0f;
    protected float myRight = 0.0f;
    protected float myBottom = 0.0f;
    protected boolean mIsOver = false;

    @Override
    public boolean canChangeSelection() {
        return true;
    }

    @Override
    public void setComponent(@NotNull SceneComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/target/BaseTarget", "setComponent"));
        }
        this.myComponent = component;
    }

    @Override
    public SceneComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public void setOver(boolean over) {
        if (over != this.mIsOver && this.myComponent != null) {
            this.myComponent.getScene().repaint();
        }
        this.mIsOver = over;
    }

    @Override
    public float getCenterX() {
        return this.myLeft + (this.myRight - this.myLeft) / 2.0f;
    }

    @Override
    public float getCenterY() {
        return this.myTop + (this.myBottom - this.myTop) / 2.0f;
    }

    @Override
    public int getMouseCursor() {
        return 0;
    }

    @Override
    public void addHit(@NotNull SceneContext transform, @NotNull ScenePicker picker) {
        if (transform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "com/android/tools/idea/uibuilder/scene/target/BaseTarget", "addHit"));
        }
        if (picker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "picker", "com/android/tools/idea/uibuilder/scene/target/BaseTarget", "addHit"));
        }
        if (!this.myComponent.getScene().allowsTarget(this)) {
            return;
        }
        picker.addRect(this, 0, transform.getSwingX(this.myLeft), transform.getSwingY(this.myTop), transform.getSwingX(this.myRight), transform.getSwingY(this.myBottom));
    }
}

