/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InstallOperation<Return, Argument> {
    protected final InstallContext myContext;
    private final double myProgressRatio;

    protected InstallOperation(InstallContext context, double progressRatio) {
        this.myContext = context;
        this.myProgressRatio = progressRatio;
    }

    public static <Return, Argument> InstallOperation<Return, Argument> wrap(@NotNull InstallContext context, @NotNull Function<Argument, Return> function, double progressShare) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/install/InstallOperation", "wrap"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/android/tools/idea/welcome/install/InstallOperation", "wrap"));
        }
        return new FunctionWrapper<Return, Argument>(context, function, progressShare);
    }

    @NotNull
    protected abstract Return perform(@NotNull ProgressIndicator var1, @NotNull Argument var2) throws WizardException, InstallationCancelledException;

    @NotNull
    public final Return execute(final @NotNull Argument argument) throws WizardException, InstallationCancelledException {
        Object r;
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/android/tools/idea/welcome/install/InstallOperation", "execute"));
        }
        this.myContext.checkCanceled();
        if (this.myProgressRatio == 0.0) {
            Return Return2 = this.perform((ProgressIndicator)new EmptyProgressIndicator(), argument);
            if (Return2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/InstallOperation", "execute"));
            }
            return Return2;
        }
        try {
            r = this.myContext.run(new ThrowableComputable<Return, Exception>(){

                @Nullable
                public Return compute() throws Exception {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    if (indicator == null) {
                        indicator = new EmptyProgressIndicator();
                    }
                    return InstallOperation.this.perform(indicator, argument);
                }
            }, this.myProgressRatio);
        }
        catch (ProcessCanceledException e) {
            throw new InstallationCancelledException();
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, WizardException.class, InstallationCancelledException.class);
            throw Throwables.propagate((Throwable)e);
        }
        if (r == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/InstallOperation", "execute"));
        }
        return (Return)r;
    }

    protected final void promptToRetry(final @NotNull String prompt, @NotNull String failureDescription, @Nullable Exception e) throws WizardException {
        if (prompt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prompt", "com/android/tools/idea/welcome/install/InstallOperation", "promptToRetry"));
        }
        if (failureDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failureDescription", "com/android/tools/idea/welcome/install/InstallOperation", "promptToRetry"));
        }
        final AtomicBoolean response = new AtomicBoolean(false);
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                int i = Messages.showYesNoDialog(null, (String)prompt, (String)"Android Studio Setup", (String)"Retry", (String)"Cancel", (Icon)Messages.getErrorIcon());
                response.set(i == 0);
            }
        }, application.getAnyModalityState());
        if (!response.get()) {
            Throwables.propagateIfInstanceOf((Throwable)e, WizardException.class);
            throw new WizardException(failureDescription, e);
        }
        this.myContext.print(failureDescription + "\n", ConsoleViewContentType.ERROR_OUTPUT);
    }

    public abstract void cleanup(@NotNull Return var1);

    public final <FinalResult> InstallOperation<FinalResult, Argument> then(@NotNull InstallOperation<FinalResult, Return> next) {
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/android/tools/idea/welcome/install/InstallOperation", "then"));
        }
        return new OperationChain(this, next);
    }

    public final <FinalResult> InstallOperation<FinalResult, Argument> then(@NotNull Function<Return, FinalResult> next) {
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/android/tools/idea/welcome/install/InstallOperation", "then"));
        }
        return this.then(InstallOperation.wrap(this.myContext, next, 0.0));
    }

    private static class FunctionWrapper<Return, Argument>
    extends InstallOperation<Return, Argument> {
        @NotNull
        private final Function<Argument, Return> myRunnable;

        public FunctionWrapper(@NotNull InstallContext context, @NotNull Function<Argument, Return> runnable, double progressShare) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/install/InstallOperation$FunctionWrapper", "<init>"));
            }
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/welcome/install/InstallOperation$FunctionWrapper", "<init>"));
            }
            super(context, progressShare);
            this.myRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected Return perform(@NotNull ProgressIndicator indicator, @NotNull Argument arg) throws WizardException {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/install/InstallOperation$FunctionWrapper", "perform"));
            }
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/welcome/install/InstallOperation$FunctionWrapper", "perform"));
            }
            indicator.start();
            Object value = this.myRunnable.apply(arg);
            assert (value != null);
            Object object = value;
            Object object2 = object;
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/InstallOperation$FunctionWrapper", "perform"));
            }
            return (Return)object2;
            finally {
                indicator.setFraction(1.0);
            }
        }

        @Override
        public void cleanup(@NotNull Return result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/welcome/install/InstallOperation$FunctionWrapper", "cleanup"));
            }
        }
    }

    private static class OperationChain<FinalResult, Argument, Return>
    extends InstallOperation<FinalResult, Argument> {
        private final InstallOperation<Return, Argument> myFirst;
        private final InstallOperation<FinalResult, Return> mySecond;

        public OperationChain(InstallOperation<Return, Argument> first, InstallOperation<FinalResult, Return> second) {
            super(first.myContext, 0.0);
            this.myFirst = first;
            this.mySecond = second;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected FinalResult perform(@NotNull ProgressIndicator indicator, @NotNull Argument argument) throws WizardException, InstallationCancelledException {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/install/InstallOperation$OperationChain", "perform"));
            }
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/android/tools/idea/welcome/install/InstallOperation$OperationChain", "perform"));
            }
            Return execute = this.myFirst.execute(argument);
            FinalResult FinalResult = this.mySecond.execute(execute);
            FinalResult FinalResult2 = FinalResult;
            if (FinalResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/InstallOperation$OperationChain", "perform"));
            }
            return FinalResult2;
            finally {
                this.myFirst.cleanup(execute);
            }
        }

        @Override
        public void cleanup(@NotNull FinalResult result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/welcome/install/InstallOperation$OperationChain", "cleanup"));
            }
            this.mySecond.cleanup(result);
        }
    }
}

