/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import org.jetbrains.android.inspections.IntRangeConstraint;
import org.jetbrains.android.inspections.RangeAllowedValues;
import org.jetbrains.android.inspections.ResourceTypeInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FloatRangeConstraint
extends RangeAllowedValues {
    final double from;
    final double to;
    final boolean fromInclusive;
    final boolean toInclusive;

    public FloatRangeConstraint(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/android/inspections/FloatRangeConstraint", "<init>"));
        }
        PsiAnnotationMemberValue fromValue = annotation.findDeclaredAttributeValue("from");
        PsiAnnotationMemberValue toValue = annotation.findDeclaredAttributeValue("to");
        PsiAnnotationMemberValue fromInclusiveValue = annotation.findDeclaredAttributeValue("fromInclusive");
        PsiAnnotationMemberValue toInclusiveValue = annotation.findDeclaredAttributeValue("toInclusive");
        this.from = ResourceTypeInspection.getDoubleValue(fromValue, Double.NEGATIVE_INFINITY);
        this.to = ResourceTypeInspection.getDoubleValue(toValue, Double.POSITIVE_INFINITY);
        this.fromInclusive = ResourceTypeInspection.getBooleanValue(fromInclusiveValue, true);
        this.toInclusive = ResourceTypeInspection.getBooleanValue(toInclusiveValue, true);
    }

    FloatRangeConstraint(double from, double to, boolean fromInclusive, boolean toInclusive) {
        this.from = from;
        this.to = to;
        this.fromInclusive = fromInclusive;
        this.toInclusive = toInclusive;
    }

    @Override
    public ResourceTypeInspection.InspectionResult isValid(@NotNull PsiExpression argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/FloatRangeConstraint", "isValid"));
        }
        Number number = this.guessSize(argument);
        if (number != null) {
            double value = number.doubleValue();
            if (!((this.fromInclusive && value >= this.from || !this.fromInclusive && value > this.from) && (this.toInclusive && value <= this.to || !this.toInclusive && value < this.to))) {
                return ResourceTypeInspection.InspectionResult.invalid(argument);
            }
            return ResourceTypeInspection.InspectionResult.valid();
        }
        return ResourceTypeInspection.InspectionResult.uncertain();
    }

    @Override
    @NotNull
    public String describe(@Nullable PsiExpression argument) {
        Number actual;
        StringBuilder sb = new StringBuilder(20);
        if (this.from != Double.NEGATIVE_INFINITY) {
            if (this.to != Double.POSITIVE_INFINITY) {
                sb.append("Value must be ");
                if (this.fromInclusive) {
                    sb.append('\u2265');
                } else {
                    sb.append('>');
                }
                sb.append(' ');
                sb.append(Double.toString(this.from));
                sb.append(" and ");
                if (this.toInclusive) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(' ');
                sb.append(Double.toString(this.to));
            } else {
                sb.append("Value must be ");
                if (this.fromInclusive) {
                    sb.append('\u2265');
                } else {
                    sb.append('>');
                }
                sb.append(' ');
                sb.append(Double.toString(this.from));
            }
        } else if (this.to != Double.POSITIVE_INFINITY) {
            sb.append("Value must be ");
            if (this.toInclusive) {
                sb.append('\u2264');
            } else {
                sb.append('<');
            }
            sb.append(' ');
            sb.append(Double.toString(this.to));
        }
        if (argument != null && (actual = this.guessSize(argument)) != null) {
            sb.append(" (was ");
            if (argument instanceof PsiLiteral) {
                PsiLiteral literal = (PsiLiteral)argument;
                sb.append(literal.getText());
            } else {
                sb.append(Double.toString(actual.doubleValue()));
            }
            sb.append(')');
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/FloatRangeConstraint", "describe"));
        }
        return string;
    }

    @Override
    public ResourceTypeInspection.InspectionResult contains(@NotNull RangeAllowedValues other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/android/inspections/FloatRangeConstraint", "contains"));
        }
        if (other instanceof FloatRangeConstraint) {
            FloatRangeConstraint otherRange = (FloatRangeConstraint)other;
            if (otherRange.from < this.from || otherRange.to > this.to) {
                return ResourceTypeInspection.InspectionResult.invalidWithoutNode();
            }
            if (!this.fromInclusive && otherRange.fromInclusive && otherRange.from == this.from) {
                return ResourceTypeInspection.InspectionResult.invalidWithoutNode();
            }
            if (!this.toInclusive && otherRange.toInclusive && otherRange.to == this.to) {
                return ResourceTypeInspection.InspectionResult.invalidWithoutNode();
            }
            return ResourceTypeInspection.InspectionResult.valid();
        }
        if (other instanceof IntRangeConstraint) {
            IntRangeConstraint otherRange = (IntRangeConstraint)other;
            if ((double)otherRange.from < this.from || (double)otherRange.to > this.to) {
                return ResourceTypeInspection.InspectionResult.invalidWithoutNode();
            }
            if (!this.fromInclusive && (double)otherRange.from == this.from) {
                return ResourceTypeInspection.InspectionResult.invalidWithoutNode();
            }
            if (!this.toInclusive && (double)otherRange.to == this.to) {
                return ResourceTypeInspection.InspectionResult.invalidWithoutNode();
            }
            return ResourceTypeInspection.InspectionResult.valid();
        }
        return ResourceTypeInspection.InspectionResult.uncertain();
    }

    public String toString() {
        return this.describe(null);
    }
}

