/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.DashboardNode;
import com.intellij.execution.dashboard.DashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PsiNavigateUtil;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationRunDashboardContributor
extends RunDashboardContributor {
    public SpringBootApplicationRunDashboardContributor() {
        super((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance());
    }

    public void updatePresentation(@NotNull PresentationData presentation, @NotNull DashboardNode node) {
        String path;
        SpringBootApplicationInfo info;
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardContributor", "updatePresentation"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardContributor", "updatePresentation"));
        }
        if (!(node instanceof DashboardRunConfigurationNode)) {
            return;
        }
        DashboardRunConfigurationNode runConfigurationNode = (DashboardRunConfigurationNode)node;
        RunConfiguration runConfiguration = runConfigurationNode.getConfigurationSettings().getConfiguration();
        if (!(runConfiguration instanceof SpringBootApplicationRunConfiguration)) {
            return;
        }
        SpringBootApplicationRunConfiguration springBootRunConfiguration = (SpringBootApplicationRunConfiguration)runConfiguration;
        if (!DumbService.getInstance((Project)runConfigurationNode.getProject()).isDumb() && SpringBootLibraryUtil.hasDevtools((Module)springBootRunConfiguration.getModule())) {
            presentation.addText(" [devtools]", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if ((info = SpringBootApplicationRunDashboardContributor.getInfo(runConfigurationNode)) != null) {
            Integer serverPort;
            if (Boolean.FALSE.equals(info.getReadyState().getValue())) {
                presentation.setIcon(AllIcons.Process.Step_4);
            }
            if ((serverPort = (Integer)info.getServerPort().getValue()) != null && serverPort > 0) {
                presentation.addText(" [:" + serverPort + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
        if (StringUtil.isNotEmpty((String)(path = springBootRunConfiguration.getUrlPath()))) {
            presentation.addText(" " + path, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
    }

    private static SpringBootApplicationInfo getInfo(@NotNull DashboardRunConfigurationNode node) {
        ProcessHandler handler;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardContributor", "getInfo"));
        }
        RunContentDescriptor descriptor = node.getDescriptor();
        if (descriptor != null && descriptor.getProcessHandler() != null && !(handler = descriptor.getProcessHandler()).isProcessTerminated()) {
            return SpringBootApplicationLifecycleManager.getInstance((Project)node.getProject()).getSpringBootApplicationInfo(handler);
        }
        return null;
    }

    public boolean isShowInDashboard(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardContributor", "isShowInDashboard"));
        }
        if (!(runConfiguration instanceof SpringBootApplicationRunConfiguration)) {
            return false;
        }
        return ((SpringBootApplicationRunConfiguration)runConfiguration).isShowInDashboard();
    }

    public boolean handleDoubleClick(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardContributor", "handleDoubleClick"));
        }
        if (!(runConfiguration instanceof SpringBootApplicationRunConfiguration)) {
            return false;
        }
        PsiClass mainClass = ((SpringBootApplicationRunConfiguration)runConfiguration).getMainClass();
        PsiNavigateUtil.navigate((PsiElement)mainClass);
        return true;
    }
}

