/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.application.BaseJavaApplicationCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

class SpringBootCommandLineState
extends BaseJavaApplicationCommandLineState<SpringBootApplicationRunConfiguration> {
    static final String DEBUG_PARAMETER = "-Ddebug";
    static final String TIERED_STOP_AT_LEVEL_1_PARAMETER = "-XX:TieredStopAtLevel=1";
    static final String NO_VERIFY_PARAMETER = "-noverify";
    static final String HIDE_BANNER_PARAMETER = "-Dspring.main.show_banner=false";
    static final String HIDE_BANNER_PARAMETER_1_5 = "-Dspring.main.banner-mode=OFF";
    static final String ACTIVE_PROFILES_PARAMETER = "-Dspring.profiles.active";
    static final String OUTPUT_ANSI_ENABLED_PARAMETER = "-Dspring.output.ansi.enabled=always";
    static final String JMX_REMOTE_PARAMETER = "-Dcom.sun.management.jmxremote";
    static final String JMX_REMOTE_PORT_PARAMETER = "com.sun.management.jmxremote.port";
    static final String JMX_REMOTE_AUTH_PARAMETER = "-Dcom.sun.management.jmxremote.authenticate=false";
    static final String JMX_REMOTE_SSL_PARAMETER = "-Dcom.sun.management.jmxremote.ssl=false";
    static final String LIVE_BEAN_PARAMETER = "-Dspring.liveBeansView.mbeanDomain";
    static final String LIFECYCLE_PARAMETER = "-Dspring.application.admin.enabled=true";
    private int myJmxPort;

    SpringBootCommandLineState(@NotNull SpringBootApplicationRunConfiguration configuration, ExecutionEnvironment environment) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/run/SpringBootCommandLineState", "<init>"));
        }
        super(environment, (RunConfigurationBase)configuration);
        this.myJmxPort = -1;
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters params = new JavaParameters();
        JavaRunConfigurationModule module = (JavaRunConfigurationModule)((SpringBootApplicationRunConfiguration)this.myConfiguration).getConfigurationModule();
        DumbService.getInstance((Project)module.getProject()).runWithAlternativeResolveEnabled(() -> {
            int classPathType = JavaParametersUtil.getClasspathType((RunConfigurationModule)module, (String)((SpringBootApplicationRunConfiguration)this.myConfiguration).getRunClass(), (boolean)false);
            String jreHome = ((SpringBootApplicationRunConfiguration)this.myConfiguration).isAlternativeJrePathEnabled() ? ((SpringBootApplicationRunConfiguration)this.myConfiguration).getAlternativeJrePath() : null;
            JavaParametersUtil.configureModule((RunConfigurationModule)module, (JavaParameters)params, (int)classPathType, (String)jreHome);
        });
        params.setMainClass(((SpringBootApplicationRunConfiguration)this.myConfiguration).getRunClass());
        params.setUseClasspathJar(true);
        this.setupJavaParameters(params);
        this.applySpringBootSettings(params);
        this.createJmxParameters(params);
        return params;
    }

    private void applySpringBootSettings(JavaParameters params) {
        ParametersList vmParametersList = params.getVMParametersList();
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isDebugMode()) {
            vmParametersList.add(DEBUG_PARAMETER);
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isEnableLaunchOptimization()) {
            vmParametersList.add(TIERED_STOP_AT_LEVEL_1_PARAMETER);
            vmParametersList.add(NO_VERIFY_PARAMETER);
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isHideBanner()) {
            if (SpringBootLibraryUtil.isAtLeastVersion((Module)((SpringBootApplicationRunConfiguration)this.myConfiguration).getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_5_0)) {
                vmParametersList.add(HIDE_BANNER_PARAMETER_1_5);
            } else {
                vmParametersList.add(HIDE_BANNER_PARAMETER);
            }
        }
        if (StringUtil.isNotEmpty((String)((SpringBootApplicationRunConfiguration)this.myConfiguration).getActiveProfiles())) {
            vmParametersList.add("-Dspring.profiles.active=" + ((SpringBootApplicationRunConfiguration)this.myConfiguration).getActiveProfiles());
        }
        vmParametersList.add(OUTPUT_ANSI_ENABLED_PARAMETER);
        for (SpringBootAdditionalParameter parameter : ((SpringBootApplicationRunConfiguration)this.myConfiguration).getAdditionalParameters()) {
            if (!parameter.isEnabled()) continue;
            String parameterValue = parameter.getValue();
            if (StringUtil.isNotEmpty((String)parameterValue)) {
                vmParametersList.add("-D" + parameter.getName() + "=" + parameterValue);
                continue;
            }
            vmParametersList.add("-D" + parameter.getName());
        }
    }

    private void createJmxParameters(JavaParameters params) throws ExecutionException {
        if (!((SpringBootApplicationRunConfiguration)this.myConfiguration).isEnableJmxAgent()) {
            return;
        }
        if (!SpringBootLibraryUtil.isAtLeastVersion((Module)((SpringBootApplicationRunConfiguration)this.myConfiguration).getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) {
            return;
        }
        ParametersList vmParametersList = params.getVMParametersList();
        vmParametersList.add(JMX_REMOTE_PARAMETER);
        String jmxPort = vmParametersList.getPropertyValue(JMX_REMOTE_PORT_PARAMETER);
        if (jmxPort != null) {
            try {
                this.myJmxPort = Integer.parseInt(jmxPort);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            try {
                this.myJmxPort = NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
            vmParametersList.add("-Dcom.sun.management.jmxremote.port=" + this.myJmxPort);
        }
        vmParametersList.add(JMX_REMOTE_AUTH_PARAMETER);
        vmParametersList.add(JMX_REMOTE_SSL_PARAMETER);
        vmParametersList.add(LIVE_BEAN_PARAMETER);
        vmParametersList.add(LIFECYCLE_PARAMETER);
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/spring/boot/run/SpringBootCommandLineState", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/spring/boot/run/SpringBootCommandLineState", "execute"));
        }
        ExecutionResult result = super.execute(executor, runner);
        if (this.myJmxPort > 0) {
            result.getProcessHandler().putUserData(SpringBootApplicationLifecycleManager.JMX_PORT, (Object)this.myJmxPort);
            SpringBootApplicationLifecycleManager.getInstance((Project)((SpringBootApplicationRunConfiguration)this.getConfiguration()).getProject());
        }
        ExecutionResult executionResult = result;
        if (executionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/SpringBootCommandLineState", "execute"));
        }
        return executionResult;
    }

    @NotNull
    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler, Executor executor) {
        AnAction openInBrowserAction;
        Object[] actions = super.createActions(console, processHandler, executor);
        if (this.myJmxPort > 0 && executor != null && DefaultRunExecutor.EXECUTOR_ID.equals(executor.getId()) && (openInBrowserAction = ActionManager.getInstance().getAction("SpringBoot.OpenInBrowser")) != null) {
            actions = (AnAction[])ArrayUtil.append((Object[])actions, (Object)openInBrowserAction);
        }
        if (actions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/SpringBootCommandLineState", "createActions"));
        }
        return actions;
    }
}

