/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractLiveProperty<T>
implements LiveProperty<T> {
    private final AtomicReference<T> myValue = new AtomicReference();
    private volatile long myTimeStamp = -1L;
    private final List<LiveProperty.LivePropertyListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    protected AbstractLiveProperty(T defaultValue) {
        this.myValue.set(defaultValue);
    }

    @Nullable
    public T getValue() {
        return this.myValue.get();
    }

    public long getTimeStamp() {
        return this.myTimeStamp;
    }

    public void addPropertyListener(@NotNull LiveProperty.LivePropertyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/spring/boot/run/lifecycle/AbstractLiveProperty", "addPropertyListener"));
        }
        this.myListeners.add(listener);
    }

    public void removePropertyListener(@NotNull LiveProperty.LivePropertyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/spring/boot/run/lifecycle/AbstractLiveProperty", "removePropertyListener"));
        }
        this.myListeners.remove(listener);
    }

    protected T setValue(T value) {
        this.myTimeStamp = System.currentTimeMillis();
        return this.myValue.getAndSet(value);
    }

    protected List<LiveProperty.LivePropertyListener> getListeners() {
        return this.myListeners;
    }
}

