/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.dashboard.DashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.AsyncLiveProperty;
import com.intellij.spring.boot.run.lifecycle.EndpointLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.ReadyStateLiveProperty;
import com.intellij.spring.boot.run.lifecycle.ServerConfigurationLiveProperty;
import com.intellij.spring.boot.run.lifecycle.ServerPortLiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootLiveBeansConnector;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansSnapshotParser;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMappingsModel;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMappingsParser;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootApplicationInfoImpl
implements SpringBootApplicationInfo {
    private static final String NOTIFICATION_DISPLAY_ID = "Spring Boot Application Endpoints";
    private final LiveProperty<Boolean> myReadyState;
    private final LiveProperty<Integer> myServerPort;
    private final LiveProperty<SpringBootApplicationServerConfiguration> myServerConfiguration;
    private final LiveProperty<LiveBeansModel> myLiveBeansModel;
    private final LiveProperty<Boolean> myActuatorsEnabled;
    private final LiveProperty<Map> myHealth;
    private final LiveProperty<LiveRequestMappingsModel> myRequestMappings;
    private volatile boolean myDisposed;

    static SpringBootApplicationInfo createInfo(@NotNull Project project, @NotNull ExecutionEnvironment environment, @NotNull SpringBootApplicationRunConfiguration configuration, int jmxPort) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "createInfo"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "createInfo"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "createInfo"));
        }
        SpringBootApplicationInfoImpl info = new SpringBootApplicationInfoImpl(project, environment, configuration, jmxPort);
        info.getReadyState().compute();
        return info;
    }

    private SpringBootApplicationInfoImpl(final @NotNull Project project, @NotNull ExecutionEnvironment environment, final @NotNull SpringBootApplicationRunConfiguration configuration, int jmxPort) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "<init>"));
        }
        LifecycleErrorHandler errorHandler = message -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "lambda$new$0"));
            }
            if (environment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "lambda$new$0"));
            }
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "lambda$new$0"));
            }
            if (this.myDisposed) {
                return;
            }
            String toolWindowId = ExecutionManager.getInstance((Project)project).getContentManager().getToolWindowIdByEnvironment(environment);
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
            if (toolWindowManager.canShowNotification(toolWindowId)) {
                new NotificationGroup(NOTIFICATION_DISPLAY_ID, NotificationDisplayType.NONE, true, toolWindowId).createNotification(configuration.getName(), message, NotificationType.ERROR, null).notify(project);
            }
        };
        this.myReadyState = new ReadyStateLiveProperty(jmxPort, (Disposable)this);
        this.myServerPort = new ServerPortLiveProperty(jmxPort, errorHandler, (Disposable)this);
        this.myServerConfiguration = new ServerConfigurationLiveProperty(jmxPort, errorHandler, (Disposable)this);
        this.myServerPort.addPropertyListener(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "lambda$new$1"));
            }
            this.myServerConfiguration.compute();
            ((DashboardListener)project.getMessageBus().syncPublisher(RunDashboardManager.DASHBOARD_TOPIC)).contentChanged(false);
        });
        this.myLiveBeansModel = new AsyncLiveProperty<LiveBeansModel>(jmxPort, errorHandler, (Disposable)this){

            @Override
            protected LiveBeansModel doCompute() throws LifecycleException {
                Throwable throwable = null;
                try (SpringBootLiveBeansConnector connector = new SpringBootLiveBeansConnector(this.getJmxPort());){
                    String snapshot = connector.getSnapshot();
                    LiveBeansSnapshotParser parser = new LiveBeansSnapshotParser();
                    LiveBeansModel liveBeansModel = parser.parse(snapshot);
                    return liveBeansModel;
                }
                catch (Exception e) {
                    try {
                        throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.application.beans.snapshot", e.getLocalizedMessage()), e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        };
        this.myActuatorsEnabled = new AsyncLiveProperty<Boolean>(jmxPort, errorHandler, (Disposable)this){

            @Override
            protected Boolean doCompute() {
                return (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                    if (configuration == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl$2", "lambda$doCompute$0"));
                    }
                    return SpringBootLibraryUtil.hasActuators((Module)configuration.getModule());
                });
            }
        };
        this.myHealth = new EndpointLiveProperty<Map>("health", "health", this.myActuatorsEnabled, jmxPort, errorHandler, (Disposable)this){

            @Override
            protected Map parseData(@Nullable Object data) {
                return (Map)data;
            }
        };
        this.myRequestMappings = new EndpointLiveProperty<LiveRequestMappingsModel>("mappings", "requestMapping", this.myActuatorsEnabled, jmxPort, errorHandler, (Disposable)this){

            @Override
            public LiveRequestMappingsModel doCompute() throws LifecycleException {
                boolean hasRequestMappings = (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                    if (configuration == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl$4", "lambda$doCompute$0"));
                    }
                    return SpringBootLibraryUtil.hasRequestMappings((Module)configuration.getModule());
                });
                if (!hasRequestMappings) {
                    return null;
                }
                return (LiveRequestMappingsModel)super.doCompute();
            }

            @Override
            protected LiveRequestMappingsModel parseData(@Nullable Object data) {
                return new LiveRequestMappingsParser().parse((Map)data);
            }
        };
        this.myReadyState.addPropertyListener(new LiveProperty.LivePropertyListener(){

            public void propertyChanged() {
                ((DashboardListener)project.getMessageBus().syncPublisher(RunDashboardManager.DASHBOARD_TOPIC)).contentChanged(true);
                SpringBootApplicationInfoImpl.this.myServerPort.compute();
                SpringBootApplicationInfoImpl.this.myLiveBeansModel.compute();
                SpringBootApplicationInfoImpl.this.myActuatorsEnabled.compute();
            }

            public void computationFailed(Exception e) {
                ((DashboardListener)project.getMessageBus().syncPublisher(RunDashboardManager.DASHBOARD_TOPIC)).contentChanged(true);
            }
        });
        this.myActuatorsEnabled.addPropertyListener(() -> {
            this.myHealth.compute();
            this.myRequestMappings.compute();
        });
    }

    @NotNull
    public LiveProperty<Boolean> getReadyState() {
        LiveProperty<Boolean> liveProperty = this.myReadyState;
        if (liveProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "getReadyState"));
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<Integer> getServerPort() {
        LiveProperty<Integer> liveProperty = this.myServerPort;
        if (liveProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "getServerPort"));
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<SpringBootApplicationServerConfiguration> getServerConfiguration() {
        LiveProperty<SpringBootApplicationServerConfiguration> liveProperty = this.myServerConfiguration;
        if (liveProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "getServerConfiguration"));
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<LiveBeansModel> getLiveBeansModel() {
        LiveProperty<LiveBeansModel> liveProperty = this.myLiveBeansModel;
        if (liveProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "getLiveBeansModel"));
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<Map> getHealth() {
        LiveProperty<Map> liveProperty = this.myHealth;
        if (liveProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "getHealth"));
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<LiveRequestMappingsModel> getRequestMappingsModel() {
        LiveProperty<LiveRequestMappingsModel> liveProperty = this.myRequestMappings;
        if (liveProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "getRequestMappingsModel"));
        }
        return liveProperty;
    }

    public void dispose() {
        this.myDisposed = true;
    }
}

