/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans;

import com.intellij.spring.boot.run.lifecycle.beans.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.LiveContext;
import com.intellij.spring.boot.run.lifecycle.beans.LiveResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveContextImpl
implements LiveContext {
    @NotNull
    private final String myName;
    private LiveContext myParent;
    private final List<LiveResource> myResources;

    LiveContextImpl(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/boot/run/lifecycle/beans/LiveContextImpl", "<init>"));
        }
        this.myResources = new ArrayList<LiveResource>();
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveContextImpl", "getName"));
        }
        return string;
    }

    @Nullable
    public LiveContext getParent() {
        return this.myParent;
    }

    @NotNull
    public List<LiveResource> getResources() {
        ArrayList<LiveResource> arrayList = new ArrayList<LiveResource>(this.myResources);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveContextImpl", "getResources"));
        }
        return arrayList;
    }

    @NotNull
    public List<LiveBean> getBeans() {
        List<LiveBean> list = this.myResources.stream().flatMap(resource -> resource.getBeans().stream()).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveContextImpl", "getBeans"));
        }
        return list;
    }

    void setParent(@Nullable LiveContext parent) {
        this.myParent = parent;
    }

    void addResources(@NotNull Collection<? extends LiveResource> resources) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/intellij/spring/boot/run/lifecycle/beans/LiveContextImpl", "addResources"));
        }
        this.myResources.addAll(resources);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LiveContextImpl)) {
            return false;
        }
        LiveContextImpl liveContext = (LiveContextImpl)obj;
        if (!this.myName.equals(liveContext.myName)) {
            return false;
        }
        if (this.myParent == null || liveContext.myParent == null) {
            return this.myParent == liveContext.myParent;
        }
        return this.myParent.getName().equals(liveContext.myParent.getName());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + (this.myParent != null ? this.myParent.getName().hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myName;
    }
}

