/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.navigation.AnonymousElementProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FilePathReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.LiveContext;
import com.intellij.spring.boot.run.lifecycle.beans.LiveResource;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveResourceImpl
implements LiveResource {
    static final String AUTO_CONFIGURATION_RESOURCE = "null";
    static final String AUTO_CONFIGURATION_RESOURCE_NAME = "Auto Configuration";
    private static final String CLASS_PATH_RESOURCE_DESCRIPTION = "class path resource";
    private static final String FILE_RESOURCE_DESCRIPTION = "file";
    private static final String URL_RESOURCE_DESCRIPTION = "URL";
    private static final String CLASS_DOT_EXTENSION = ".class";
    private static final String XML_DOT_EXTENSION = ".xml";
    @NotNull
    private final String myDescription;
    @NotNull
    private final LiveContext myContext;
    @NotNull
    private final List<LiveBean> myBeans;
    private volatile String myDisplayName;

    LiveResourceImpl(@NotNull String description, @NotNull LiveContext context) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "<init>"));
        }
        this.myBeans = ContainerUtil.newSmartList();
        this.myDescription = description;
        this.myContext = context;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getDescription"));
        }
        return string;
    }

    @NotNull
    public LiveContext getContext() {
        LiveContext liveContext = this.myContext;
        if (liveContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getContext"));
        }
        return liveContext;
    }

    @NotNull
    public List<LiveBean> getBeans() {
        List beans = ContainerUtil.newSmartList();
        beans.addAll(this.myBeans);
        List list = beans;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getBeans"));
        }
        return list;
    }

    public boolean hasDescription() {
        return !this.myDescription.isEmpty() && !this.myDescription.equalsIgnoreCase(AUTO_CONFIGURATION_RESOURCE);
    }

    @NotNull
    public String getDisplayName() {
        String displayName = this.myDisplayName;
        if (displayName != null) {
            String string = displayName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getDisplayName"));
            }
            return string;
        }
        if (!this.hasDescription()) {
            String string = this.myDisplayName = AUTO_CONFIGURATION_RESOURCE_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getDisplayName"));
            }
            return string;
        }
        displayName = this.myDescription;
        int indexStart = displayName.lastIndexOf("/");
        int indexEnd = displayName.lastIndexOf("]");
        if (indexStart > -1 && indexEnd > -1 && indexStart < indexEnd) {
            displayName = displayName.substring(indexStart + 1, indexEnd);
        }
        if (LiveResourceImpl.isXmlResource(displayName)) {
            String string = this.myDisplayName = displayName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getDisplayName"));
            }
            return string;
        }
        int index = (displayName = StringUtil.trimEnd((String)displayName, (String)CLASS_DOT_EXTENSION)).lastIndexOf(".");
        if (index > -1) {
            displayName = displayName.substring(index + 1);
        }
        String[] names = displayName.split("\\$");
        StringBuilder sb = new StringBuilder();
        sb.append(names[names.length - 1]);
        for (int i = names.length - 2; i >= 0; --i) {
            sb.append(" in ");
            sb.append(names[i]);
        }
        String string = this.myDisplayName = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getDisplayName"));
        }
        return string;
    }

    @Nullable
    public Navigatable getResourceNavigatable(@NotNull Project project, @Nullable Module module, @Nullable PsiElement runConfigurationElement, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getResourceNavigatable"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getResourceNavigatable"));
        }
        if (!this.hasDescription()) {
            return null;
        }
        if (this.myDescription.indexOf(91) < 0) {
            return LiveResourceImpl.findClass(this.myDescription, project, searchScope);
        }
        String path = this.getResourcePath();
        if (this.myDescription.startsWith(CLASS_PATH_RESOURCE_DESCRIPTION)) {
            return LiveResourceImpl.getClassPathResource(path, project, module, runConfigurationElement, searchScope);
        }
        if (this.myDescription.startsWith(FILE_RESOURCE_DESCRIPTION)) {
            return LiveResourceImpl.getFileResource(path, project, searchScope);
        }
        if (this.myDescription.startsWith(URL_RESOURCE_DESCRIPTION)) {
            return new UrlNavigatable(path);
        }
        return null;
    }

    @Nullable
    public PsiElement getResourceElement(@NotNull Project project, @Nullable Module module, @Nullable PsiElement runConfigurationElement, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getResourceElement"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getResourceElement"));
        }
        Navigatable navigatable = this.getResourceNavigatable(project, module, runConfigurationElement, searchScope);
        return navigatable instanceof PsiElement ? (PsiElement)navigatable : null;
    }

    @Nullable
    public Icon getIcon() {
        if (!this.hasDescription()) {
            return SpringApiIcons.SpringJavaConfig;
        }
        if (this.myDescription.indexOf(91) < 0) {
            return AllIcons.Nodes.Class;
        }
        String path = this.getResourcePath();
        if (this.myDescription.startsWith(CLASS_PATH_RESOURCE_DESCRIPTION) || this.myDescription.startsWith(FILE_RESOURCE_DESCRIPTION)) {
            if (LiveResourceImpl.isClassResource(path)) {
                return AllIcons.Nodes.Class;
            }
            if (LiveResourceImpl.isXmlResource(path)) {
                return SpringApiIcons.SpringConfig;
            }
        } else if (this.myDescription.startsWith(URL_RESOURCE_DESCRIPTION)) {
            return AllIcons.Javaee.Web_xml;
        }
        return null;
    }

    @NotNull
    public String getResourcePath() {
        String resource = this.myDescription;
        int start = resource.indexOf("[");
        int end = resource.indexOf("]");
        if (start > -1 && end > -1 && start < end) {
            resource = resource.substring(start + 1, end);
        }
        String string = resource;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getResourcePath"));
        }
        return string;
    }

    void addBean(@NotNull LiveBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "addBean"));
        }
        this.myBeans.add(bean);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LiveResourceImpl) {
            LiveResourceImpl liveResource = (LiveResourceImpl)obj;
            return this.myDescription.equals(liveResource.myDescription) && this.myContext.equals(liveResource.myContext);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.myDescription.hashCode();
        result = 31 * result + this.myContext.hashCode();
        return result;
    }

    public String toString() {
        return this.myDescription;
    }

    private static boolean isXmlResource(String path) {
        return StringUtil.endsWithIgnoreCase((String)path, (String)XML_DOT_EXTENSION);
    }

    static boolean isClassResource(String path) {
        return StringUtil.endsWithIgnoreCase((String)path, (String)CLASS_DOT_EXTENSION);
    }

    static PsiClass findClass(@NotNull String className, @NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        PsiClass psiClass;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "findClass"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "findClass"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "findClass"));
        }
        String innerClassesSuffix = null;
        int index = className.indexOf(36);
        if (index >= 0) {
            innerClassesSuffix = className.substring(index + 1);
            className = className.substring(0, index);
        }
        if ((psiClass = JavaExecutionUtil.findMainClass((Project)project, (String)className, (GlobalSearchScope)searchScope)) == null || innerClassesSuffix == null) {
            return psiClass;
        }
        return LiveResourceImpl.findInnerClass(psiClass, innerClassesSuffix);
    }

    private static PsiClass findInnerClass(@NotNull PsiClass parent, @NotNull String innerClassesSuffix) {
        String[] innerClasses;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "findInnerClass"));
        }
        if (innerClassesSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClassesSuffix", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "findInnerClass"));
        }
        block2: for (String innerClassName : innerClasses = innerClassesSuffix.split("\\$")) {
            if (innerClassName.isEmpty()) {
                return parent;
            }
            if (StringUtil.isDecimalDigit((char)innerClassName.charAt(0))) {
                try {
                    int classIndex = Integer.parseInt(innerClassName) - 1;
                    for (AnonymousElementProvider provider : (AnonymousElementProvider[])Extensions.getExtensions((ExtensionPointName)AnonymousElementProvider.EP_NAME)) {
                        PsiElement[] elements = provider.getAnonymousElements((PsiElement)parent);
                        if (classIndex >= elements.length) continue;
                        PsiElement anonymousElement = elements[classIndex];
                        if (!(anonymousElement instanceof PsiClass)) {
                            return parent;
                        }
                        parent = (PsiClass)anonymousElement;
                        continue block2;
                    }
                    continue;
                }
                catch (NumberFormatException e) {
                    return parent;
                }
            }
            PsiClass innerClass = parent.findInnerClassByName(innerClassName, false);
            if (innerClass == null) {
                return parent;
            }
            parent = innerClass;
        }
        return parent;
    }

    private static NavigatablePsiElement getClassPathResource(@NotNull String path, @NotNull Project project, @Nullable Module module, @Nullable PsiElement runConfigurationElement, @NotNull GlobalSearchScope searchScope) {
        PsiElement element;
        PsiReference reference;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getClassPathResource"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getClassPathResource"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getClassPathResource"));
        }
        if (LiveResourceImpl.isClassResource(path)) {
            path = StringUtil.trimEnd((String)path, (String)CLASS_DOT_EXTENSION, (boolean)true);
            path = path.replaceAll("[\\\\/]", ".");
            return LiveResourceImpl.findClass(path, project, searchScope);
        }
        if (module == null || runConfigurationElement == null) {
            return null;
        }
        PsiReference[] references = new FilePathReferenceProvider().getReferencesByElement(runConfigurationElement, path, 0, true, new Module[]{module});
        if (references.length > 0 && (reference = references[references.length - 1]) != null && (element = reference.resolve()) != null) {
            return element.getContainingFile();
        }
        return null;
    }

    private static NavigatablePsiElement getFileResource(@NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        VirtualFile resourceFile;
        int index;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getFileResource"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getFileResource"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl", "getFileResource"));
        }
        String innerClassesSuffix = null;
        if (LiveResourceImpl.isClassResource(path) && (index = path.indexOf(36)) >= 0) {
            innerClassesSuffix = StringUtil.trimEnd((String)path.substring(index + 1), (String)CLASS_DOT_EXTENSION, (boolean)true);
            path = path.substring(0, index) + path.substring(path.length() - CLASS_DOT_EXTENSION.length());
        }
        if ((resourceFile = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false)) != null) {
            PsiClass[] classes;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(resourceFile);
            if (psiFile instanceof PsiClassOwner && (classes = ((PsiClassOwner)psiFile).getClasses()).length > 0) {
                PsiClass psiClass = JavaExecutionUtil.findMainClass((Project)project, (String)classes[0].getQualifiedName(), (GlobalSearchScope)searchScope);
                if (psiClass != null && innerClassesSuffix != null) {
                    psiClass = LiveResourceImpl.findInnerClass(psiClass, innerClassesSuffix);
                }
                if (psiClass != null) {
                    return psiClass;
                }
            }
            return psiFile;
        }
        return null;
    }

    private static class UrlNavigatable
    implements Navigatable {
        @NotNull
        private final String myUrl;

        UrlNavigatable(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/spring/boot/run/lifecycle/beans/LiveResourceImpl$UrlNavigatable", "<init>"));
            }
            this.myUrl = url;
        }

        public void navigate(boolean requestFocus) {
            BrowserUtil.browse((String)this.myUrl);
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UrlNavigatable) {
                return this.myUrl.equals(((UrlNavigatable)obj).myUrl);
            }
            return false;
        }

        public int hashCode() {
            return this.myUrl.hashCode();
        }
    }
}

