/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.diagram;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBean;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveBeansPanel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.xml.util.PsiElementPointer;
import icons.SpringApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveBeanWrapper
extends SpringElementWrapper<LiveBean> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiElementPointer myPointer;

    LiveBeanWrapper(@NotNull LiveBean bean, @NotNull LiveBeansPanel.LiveBeanContext beanContext) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanWrapper", "<init>"));
        }
        if (beanContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanContext", "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanWrapper", "<init>"));
        }
        super((Object)bean);
        this.myProject = beanContext.project;
        if (DumbService.isDumb((Project)this.myProject)) {
            this.myPointer = () -> null;
        } else {
            PsiElement resourceElement = bean.getResource() == null ? null : bean.getResource().getResourceElement(beanContext.project, beanContext.module, (PsiElement)beanContext.mainClass, beanContext.searchScope);
            PsiClass beanClass = bean.getBeanClass(beanContext.project, beanContext.searchScope);
            this.myPointer = bean.getBeanPointer(beanClass, resourceElement, beanContext.springModel);
        }
    }

    public String getName() {
        return ((LiveBean)this.getWrapped()).getName();
    }

    @Nullable
    public CommonSpringModel getProcessingSpringModel(boolean localModel) {
        return null;
    }

    @Nullable
    public String getFqn() {
        return ((LiveBean)this.getWrapped()).getClassName();
    }

    @Nullable
    public Module getModule() {
        return null;
    }

    @Nullable
    public Icon getIcon() {
        PsiElementPointer pointer = this.getPointer();
        return pointer instanceof SpringBeanPointer ? SpringPresentationProvider.getSpringIcon((Object)pointer) : SpringApiIcons.SpringJavaBean;
    }

    @NotNull
    public PsiElementPointer getPointer() {
        PsiElementPointer psiElementPointer = DumbService.isDumb((Project)this.myProject) ? () -> null : this.myPointer;
        if (psiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanWrapper", "getPointer"));
        }
        return psiElementPointer;
    }
}

