/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.mappings;

import com.intellij.openapi.util.Comparing;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveHandlerMethod;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveHandlerMethodImpl;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMapping;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveRequestMappingImpl
implements LiveRequestMapping {
    private static final String REQUEST_METHODS_PART = ",methods=[";
    private static final String PRODUCES_PART = ",produces=[";
    @NotNull
    private final String myMapping;
    @NotNull
    private final String myPath;
    @Nullable
    private final String myBean;
    @Nullable
    private final LiveHandlerMethod myMethod;
    @NotNull
    private final List<String> myRequestMethods;
    @Nullable
    private final String myProduces;

    LiveRequestMappingImpl(@NotNull String mapping, @NotNull String path, @Nullable String bean, @Nullable String method) {
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingImpl", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingImpl", "<init>"));
        }
        this.myMapping = mapping;
        this.myPath = path;
        this.myBean = bean;
        this.myMethod = method != null ? new LiveHandlerMethodImpl(method) : null;
        this.myRequestMethods = LiveRequestMappingImpl.parseRequestMethods(mapping);
        this.myProduces = LiveRequestMappingImpl.parseProduces(mapping);
    }

    @NotNull
    public String getMapping() {
        String string = this.myMapping;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingImpl", "getMapping"));
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingImpl", "getPath"));
        }
        return string;
    }

    @NotNull
    public List<String> getRequestMethods() {
        List<String> list = Collections.unmodifiableList(this.myRequestMethods);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingImpl", "getRequestMethods"));
        }
        return list;
    }

    @Nullable
    public String getProduces() {
        return this.myProduces;
    }

    @Nullable
    public String getBean() {
        return this.myBean;
    }

    @Nullable
    public LiveHandlerMethod getMethod() {
        return this.myMethod;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LiveRequestMappingImpl) {
            LiveRequestMappingImpl liveMapping = (LiveRequestMappingImpl)obj;
            return this.myMapping.equals(liveMapping.myMapping) && this.myPath.equals(liveMapping.myPath) && Comparing.equal((String)this.myBean, (String)liveMapping.myBean) && Comparing.equal((Object)this.myMethod, (Object)liveMapping.myMethod);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.myMapping.hashCode();
        result = 31 * result + this.myPath.hashCode();
        result = 31 * result + (this.myBean != null ? this.myBean.hashCode() : 0);
        result = 31 * result + (this.myMethod != null ? this.myMethod.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myMapping;
    }

    @NotNull
    private static List<String> parseRequestMethods(String mapping) {
        int end;
        int requestMethodsIndex = mapping.indexOf(REQUEST_METHODS_PART);
        if (requestMethodsIndex >= 0 && (end = mapping.indexOf(93, requestMethodsIndex)) > requestMethodsIndex) {
            String methods = mapping.substring(requestMethodsIndex + REQUEST_METHODS_PART.length(), end);
            List<String> list = Arrays.stream(methods.split(Pattern.quote("||"))).map(String::trim).collect(Collectors.toList());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingImpl", "parseRequestMethods"));
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/mappings/LiveRequestMappingImpl", "parseRequestMethods"));
        }
        return list;
    }

    @Nullable
    private static String parseProduces(String mapping) {
        int end;
        int producesIndex = mapping.indexOf(PRODUCES_PART);
        if (producesIndex >= 0 && (end = mapping.indexOf(93, producesIndex)) > producesIndex) {
            return mapping.substring(producesIndex + PRODUCES_PART.length(), end);
        }
        return null;
    }
}

