/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.tabs.EndpointTab;
import com.intellij.spring.boot.run.lifecycle.tabs.HealthEndpointTabSettings;
import com.intellij.spring.boot.run.lifecycle.tabs.HealthTreeStructure;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringBootRunIcons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;

class HealthTab
extends EndpointTab {
    private static final String TAB_ID = "health";
    private final JComponent myComponent;
    private final HealthTreeStructure myTreeStructure;
    private final AbstractTreeBuilder myBuilder;
    private final TreeExpander myExpander;
    private final Alarm myAlarm;
    private final LiveProperty.LivePropertyListener myPropertyListener;

    HealthTab(@NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/spring/boot/run/lifecycle/tabs/HealthTab", "<init>"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/spring/boot/run/lifecycle/tabs/HealthTab", "<init>"));
        }
        super(runConfiguration, processHandler);
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        Tree tree = new Tree((TreeModel)treeModel);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(false);
        tree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        tree.setLineStyleAngled();
        this.myTreeStructure = new HealthTreeStructure(this.getProject());
        this.myBuilder = new SimpleTreeBuilder((JTree)tree, treeModel, (AbstractTreeStructure)this.myTreeStructure, (Comparator)IndexComparator.INSTANCE);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        new TreeSpeedSearch(tree, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING, true);
        this.myExpander = new DefaultTreeExpander((JTree)tree);
        this.myComponent = ScrollPaneFactory.createScrollPane((Component)tree, (int)20, (int)31);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myAlarm.setActivationComponent((JComponent)this.getRootPanel());
        this.myPropertyListener = new LiveProperty.LivePropertyListener(){

            public void propertyChanged() {
            }

            public void computationFinished() {
                HealthTab.this.scheduleHealthCheck();
            }
        };
        this.getProject().getMessageBus().connect((Disposable)this).subscribe(SpringBootEndpointsTabSettings.TOPIC, (Object)new SpringBootEndpointsTabSettings.Listener(){

            @Override
            public void settingsChanged(SpringBootEndpointsTabSettings.ChangeType changeType) {
                switch (changeType) {
                    case HEALTH_CHECK: {
                        HealthTab.this.scheduleHealthCheck();
                        break;
                    }
                }
            }
        });
    }

    @Override
    @NotNull
    public String getId() {
        if (TAB_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/HealthTab", "getId"));
        }
        return TAB_ID;
    }

    @Override
    public String getTitle() {
        return SpringBootRunBundle.message("spring.boot.application.endpoints.health.tab.title", new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return SpringBootRunIcons.SpringBootHealth;
    }

    @Override
    @NotNull
    protected List<AnAction> getToolbarActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add(new ExpandAllAction());
        actions.add(new CollapseAllAction());
        actions.add((AnAction)Separator.getInstance());
        actions.add(new AnAction(SpringBootRunBundle.message("spring.boot.application.endpoints.configure.health.tab.action.name", new Object[0]), null, AllIcons.CodeStyle.Gear){

            public void actionPerformed(AnActionEvent e) {
                ShowSettingsUtil.getInstance().showSettingsDialog(HealthTab.this.getProject(), SpringBootApiBundle.message((String)"settings.displayName", (Object[])new Object[0]));
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setVisible(HealthTab.this.isTabSelected(e));
            }
        });
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/HealthTab", "getToolbarActions"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<LiveProperty.LivePropertyListener> getPropertyListeners() {
        List list = ContainerUtil.newSmartList((Object)this.myPropertyListener);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/HealthTab", "getPropertyListeners"));
        }
        return list;
    }

    @Override
    @NotNull
    protected LiveProperty getLiveProperty(SpringBootApplicationInfo info) {
        LiveProperty liveProperty = info.getHealth();
        if (liveProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/HealthTab", "getLiveProperty"));
        }
        return liveProperty;
    }

    @Override
    @NotNull
    protected JComponent getEndpointComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/HealthTab", "getEndpointComponent"));
        }
        return jComponent;
    }

    @Override
    protected void updateComponent() {
        SpringBootApplicationInfo info = this.getInfo();
        Map appHealth = info != null ? (Map)info.getHealth().getValue() : null;
        long timeStamp = info != null ? info.getHealth().getTimeStamp() : -1L;
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.getProject(), () -> {
            this.setTimeStampTooltip(timeStamp);
            this.myTreeStructure.setHealth(appHealth);
            this.myBuilder.queueUpdate();
        });
    }

    @Override
    protected String getErrorMessage(String cause) {
        return SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.endpoint.data", TAB_ID, cause);
    }

    @Override
    public void updateRefreshAction(AnActionEvent e, @NotNull SpringBootApplicationInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/spring/boot/run/lifecycle/tabs/HealthTab", "updateRefreshAction"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        HealthEndpointTabSettings settings = HealthEndpointTabSettings.getInstance(project);
        if (settings.isCheckHealth() && Boolean.TRUE.equals(info.getReadyState().getValue())) {
            Presentation presentation = e.getPresentation();
            presentation.setIcon(ExecutionUtil.getLiveIndicator((Icon)AllIcons.Actions.Refresh));
            presentation.setText(SpringBootRunBundle.message("spring.boot.application.endpoints.health.tab.refresh.action.name", TimeUnit.MILLISECONDS.toSeconds(settings.getHealthCheckDelay())));
        }
    }

    private void scheduleHealthCheck() {
        Project project = this.getProject();
        if (!project.isOpen() || project.isDisposed()) {
            return;
        }
        HealthEndpointTabSettings settings = HealthEndpointTabSettings.getInstance(project);
        this.myAlarm.cancelAllRequests();
        long delay = settings.getHealthCheckDelay();
        if (settings.isCheckHealth() && delay > 0L && !this.myAlarm.isDisposed()) {
            this.myAlarm.addRequest(() -> {
                SpringBootApplicationInfo info = this.getInfo();
                if (info != null) {
                    info.getHealth().compute();
                }
            }, delay);
        }
    }

    private class CollapseAllAction
    extends AnAction {
        CollapseAllAction() {
            this.copyFrom(ActionManager.getInstance().getAction("CollapseAll"));
            this.registerCustomShortcutSet(this.getShortcutSet(), HealthTab.this.myComponent);
        }

        public void actionPerformed(AnActionEvent e) {
            if (HealthTab.this.myExpander.canCollapse()) {
                HealthTab.this.myExpander.collapseAll();
            }
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            boolean visible = HealthTab.this.isTabSelected(e);
            presentation.setVisible(visible);
            presentation.setEnabled(visible && HealthTab.this.myExpander.canCollapse());
        }
    }

    private class ExpandAllAction
    extends AnAction {
        ExpandAllAction() {
            this.copyFrom(ActionManager.getInstance().getAction("ExpandAll"));
            this.registerCustomShortcutSet(this.getShortcutSet(), HealthTab.this.myComponent);
        }

        public void actionPerformed(AnActionEvent e) {
            if (HealthTab.this.myExpander.canExpand()) {
                HealthTab.this.myExpander.expandAll();
            }
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            boolean visible = HealthTab.this.isTabSelected(e);
            presentation.setVisible(visible);
            presentation.setEnabled(visible && HealthTab.this.myExpander.canExpand());
        }
    }
}

