/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMapping;
import com.intellij.spring.boot.run.lifecycle.tabs.RequestMappingsPanel;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.JBDimension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RequestMappingsConfigurable
extends DialogWrapper {
    private JPanel myRootPanel;
    private JPanel myFieldPanel;
    private TextFieldWithCompletion myPathField;
    @NotNull
    private final Project myProject;
    @NotNull
    private final SpringBootApplicationRunConfiguration myRunConfiguration;
    @NotNull
    private final List<LiveRequestMapping> myMappings;

    RequestMappingsConfigurable(@NotNull Project project, @NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull List<LiveRequestMapping> mappings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsConfigurable", "<init>"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsConfigurable", "<init>"));
        }
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsConfigurable", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myMappings = mappings;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.path.dialog.title", new Object[0]));
    }

    private void createUIComponents() {
        this.myFieldPanel = new JPanel(new BorderLayout());
        this.myFieldPanel.setPreferredSize((Dimension)new JBDimension(300, -1));
        String text = this.myRunConfiguration.getUrlPath();
        if (text == null) {
            text = "";
        }
        this.myPathField = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletionListProvider<LiveRequestMapping>(this.myMappings){

            @NotNull
            protected String getLookupString(@NotNull LiveRequestMapping item) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsConfigurable$1", "getLookupString"));
                }
                String string = item.getPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsConfigurable$1", "getLookupString"));
                }
                return string;
            }

            @Nullable
            protected String getTailText(@NotNull LiveRequestMapping item) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsConfigurable$1", "getTailText"));
                }
                return RequestMappingsPanel.getDisplayRequestMethods(item);
            }
        }, true, text);
        this.myFieldPanel.add((Component)this.myPathField, "Center");
    }

    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPathField;
    }

    protected void doOKAction() {
        RequestMappingsConfigurable.updatePath(this.myProject, this.myRunConfiguration, this.myPathField.getText());
        super.doOKAction();
    }

    static void updatePath(@NotNull Project project, @NotNull SpringBootApplicationRunConfiguration runConfiguration, String path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsConfigurable", "updatePath"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsConfigurable", "updatePath"));
        }
        RunManagerImpl runManager = (RunManagerImpl)RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings configurationSettings = runManager.findConfigurationByName(runConfiguration.getName());
        if (configurationSettings == null) {
            return;
        }
        if (configurationSettings.getConfiguration() instanceof SpringBootApplicationRunConfiguration) {
            ((SpringBootApplicationRunConfiguration)configurationSettings.getConfiguration()).setUrlPath(path);
            runConfiguration.setUrlPath(path);
            runManager.fireRunConfigurationChanged(configurationSettings);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/SpringBootRunBundle").getString("spring.boot.application.endpoints.mappings.path.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = this.myFieldPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

