/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMapping;
import com.intellij.spring.boot.run.lifecycle.mappings.LiveRequestMappingsModel;
import com.intellij.spring.boot.run.lifecycle.tabs.EndpointTab;
import com.intellij.spring.boot.run.lifecycle.tabs.RequestMappingsConfigurable;
import com.intellij.spring.boot.run.lifecycle.tabs.RequestMappingsPanel;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class RequestMappingsTab
extends EndpointTab {
    private static final String TAB_ID = "mappings";
    private static final String[] REQUEST_METHODS = new String[]{"GET", "HEAD", "POST", "PUT", "PATCH", "DELETE", "OPTIONS", "TRACE"};
    private final List<LiveRequestMapping> myRequestMappings;
    private final JComponent myWrapper;
    private final RequestMappingsPanel myRequestMappingsPanel;

    RequestMappingsTab(@NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab", "<init>"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab", "<init>"));
        }
        super(runConfiguration, processHandler);
        this.myRequestMappings = new ArrayList<LiveRequestMapping>();
        this.myRequestMappingsPanel = new RequestMappingsPanel(this.getProject(), this.getRunConfiguration(), (List<AnAction>)new SmartList((Object)new MarkAsDefaultAction()));
        this.myRequestMappingsPanel.setDefaultPath(runConfiguration.getUrlPath());
        Disposer.register((Disposable)this, (Disposable)this.myRequestMappingsPanel);
        this.myWrapper = DumbService.getInstance((Project)this.getProject()).wrapGently((JComponent)this.myRequestMappingsPanel, (Disposable)this);
        MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
        connection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab$1", "runConfigurationChanged"));
                }
                if (RequestMappingsTab.this.getRunConfiguration().getName().equals(settings.getName())) {
                    RequestMappingsTab.this.myRequestMappingsPanel.setDefaultPath(RequestMappingsTab.this.getRunConfiguration().getUrlPath());
                }
            }
        });
        connection.subscribe(SpringBootEndpointsTabSettings.TOPIC, (Object)new SpringBootEndpointsTabSettings.Listener(){

            @Override
            public void settingsChanged(SpringBootEndpointsTabSettings.ChangeType changeType) {
                switch (changeType) {
                    case REQUEST_MAPPINGS: {
                        RequestMappingsTab.this.myRequestMappingsPanel.setItems(Collections.unmodifiableList(RequestMappingsTab.this.myRequestMappings));
                        break;
                    }
                }
            }
        });
    }

    @Override
    @NotNull
    public String getId() {
        if (TAB_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab", "getId"));
        }
        return TAB_ID;
    }

    @Override
    public String getTitle() {
        return SpringBootRunBundle.message("spring.boot.application.endpoints.request.mappings.tab.title", new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return SpringApiIcons.RequestMapping;
    }

    @Override
    @NotNull
    protected List<AnAction> getToolbarActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add(new AnAction(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.default.action.name", new Object[0]), null, AllIcons.Actions.EditSource){

            public void actionPerformed(AnActionEvent e) {
                new RequestMappingsConfigurable(RequestMappingsTab.this.getProject(), RequestMappingsTab.this.getRunConfiguration(), Collections.unmodifiableList(RequestMappingsTab.this.myRequestMappings)).show();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setVisible(RequestMappingsTab.this.isTabSelected(e));
            }
        });
        actions.add(new MarkAsDefaultAction());
        actions.add((AnAction)Separator.getInstance());
        actions.add((AnAction)new LiveRequestMethodActionGroup());
        actions.add((AnAction)Separator.getInstance());
        actions.add((AnAction)new EndpointTab.EndpointToggleAction(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.show.library.mappings.action.name", new Object[0]), null, AllIcons.Modules.Library){

            public boolean isSelected(AnActionEvent e) {
                return RequestMappingsTab.this.getSettings().isShowLibraryMappings();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SpringBootEndpointsTabSettings settings = SpringBootEndpointsTabSettings.getInstance(RequestMappingsTab.this.getProject());
                settings.setShowLibraryMappings(state);
                settings.fireSettingsChanged(SpringBootEndpointsTabSettings.ChangeType.REQUEST_MAPPINGS);
            }
        });
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab", "getToolbarActions"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected LiveProperty getLiveProperty(SpringBootApplicationInfo info) {
        LiveProperty liveProperty = info.getRequestMappingsModel();
        if (liveProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab", "getLiveProperty"));
        }
        return liveProperty;
    }

    @Override
    @NotNull
    protected JComponent getEndpointComponent() {
        JComponent jComponent = this.myWrapper;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab", "getEndpointComponent"));
        }
        return jComponent;
    }

    @Override
    protected void updateComponent() {
        SpringBootApplicationInfo info = SpringBootApplicationLifecycleManager.getInstance((Project)this.getRunConfiguration().getProject()).getSpringBootApplicationInfo(this.getProcessHandler());
        LiveRequestMappingsModel model = info != null ? (LiveRequestMappingsModel)info.getRequestMappingsModel().getValue() : null;
        long timeStamp = info != null ? info.getHealth().getTimeStamp() : -1L;
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.getProject(), () -> {
            this.setTimeStampTooltip(timeStamp);
            this.myRequestMappings.clear();
            if (model != null) {
                this.myRequestMappings.addAll(model.getRequestMappings());
            }
            this.myRequestMappingsPanel.setItems(Collections.unmodifiableList(this.myRequestMappings));
        });
    }

    @Override
    protected String getErrorMessage(String cause) {
        return SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.endpoint.data", TAB_ID, cause);
    }

    private class LiveRequestMethodActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        LiveRequestMethodActionGroup() {
            this.setPopup(true);
            this.getTemplatePresentation().setText(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.request.method.action.name", new Object[0]));
            this.getTemplatePresentation().setIcon(AllIcons.Nodes.Method);
            for (final String method : REQUEST_METHODS) {
                this.add((AnAction)new EndpointTab.EndpointToggleAction(method){

                    public boolean isSelected(AnActionEvent e) {
                        return !RequestMappingsTab.this.getSettings().getFilteredRequestMethods().contains(method);
                    }

                    public void setSelected(AnActionEvent e, boolean state) {
                        SpringBootEndpointsTabSettings settings = RequestMappingsTab.this.getSettings();
                        if (state) {
                            settings.getFilteredRequestMethods().remove(method);
                        } else {
                            settings.getFilteredRequestMethods().add(method);
                        }
                        settings.fireSettingsChanged(SpringBootEndpointsTabSettings.ChangeType.REQUEST_MAPPINGS);
                    }

                    @Override
                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab$LiveRequestMethodActionGroup$1", "update"));
                        }
                        super.update(e);
                        if (!e.getPresentation().isEnabled()) {
                            e.getPresentation().setVisible(false);
                        }
                    }
                });
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/tabs/RequestMappingsTab$LiveRequestMethodActionGroup", "update"));
            }
            RequestMappingsTab.this.updateActionPresentation(e);
        }
    }

    private class MarkAsDefaultAction
    extends AnAction {
        MarkAsDefaultAction() {
            super(SpringBootRunBundle.message("spring.boot.application.endpoints.mappings.mark.default.action.name", new Object[0]), null, AllIcons.Actions.Submit1);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(RequestMappingsTab.this.isTabSelected(e));
            LiveRequestMapping mapping = RequestMappingsTab.this.myRequestMappingsPanel.getSelectedMapping();
            String path = mapping != null ? mapping.getPath() : null;
            e.getPresentation().setEnabled(path != null);
        }

        public void actionPerformed(AnActionEvent e) {
            String path;
            LiveRequestMapping mapping = RequestMappingsTab.this.myRequestMappingsPanel.getSelectedMapping();
            String string = path = mapping != null ? mapping.getPath() : null;
            if (path == null) {
                return;
            }
            RequestMappingsConfigurable.updatePath(RequestMappingsTab.this.getProject(), RequestMappingsTab.this.getRunConfiguration(), path);
        }
    }
}

