/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlKeyReferenceProvider;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlValueReferenceProvider;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.constants.SpringReferencePatternConditions;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;

public class SpringBootApplicationYamlReferenceContributor
extends PsiReferenceContributor {
    static final PatternCondition<PsiElement> APPLICATION_YAML_SB_1_2_OR_HIGHER = new PatternCondition<PsiElement>("isApplicationYamlAndSB_1_2"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlReferenceContributor$1", "accepts"));
            }
            if (!SpringReferencePatternConditions.PROJECT_HAS_SPRING_FACETS_CONDITION.accepts((Object)element, context)) {
                return false;
            }
            if (!SpringBootApplicationYamlUtil.isInsideApplicationYamlFile(element)) {
                return false;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            return SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0);
        }
    };

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlReferenceContributor", "registerReferenceProviders"));
        }
        SpringBootApplicationYamlReferenceContributor.registerKeyProviders(registrar);
        SpringBootApplicationYamlReferenceContributor.registerValueProviders(registrar);
    }

    private static void registerKeyProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlReferenceContributor", "registerKeyProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(YAMLKeyValue.class).with(APPLICATION_YAML_SB_1_2_OR_HIGHER), (PsiReferenceProvider)new SpringBootApplicationYamlKeyReferenceProvider());
    }

    private static void registerValueProviders(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(YAMLScalar.class).with(APPLICATION_YAML_SB_1_2_OR_HIGHER), (PsiReferenceProvider)new SpringBootApplicationYamlValueReferenceProvider());
    }
}

