/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.refactoring.pushIn;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.lang.aspectj.psi.PsiInterTypeTypeAnnotation;
import com.intellij.lang.aspectj.refactoring.pushIn.InterTypeUsageInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.move.moveMembers.MoveMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PushInProcessingTask
implements SequentialTask {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.aspectj.refactoring.pushIn.PushInProcessingTask");
    private final UsageInfo[] myUsages;
    private final SequentialModalProgressTask myProgressTask;
    private final boolean myDeleteAspects;
    private List<Step> mySteps;
    private ProgressIndicator myIndicator;
    private int myCount;

    public PushInProcessingTask(@NotNull UsageInfo[] usages, @NotNull SequentialModalProgressTask progressTask, boolean deleteAspects) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessingTask", "<init>"));
        }
        if (progressTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTask", "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessingTask", "<init>"));
        }
        this.myCount = 0;
        this.myUsages = usages;
        this.myProgressTask = progressTask;
        this.myDeleteAspects = deleteAspects;
    }

    @NotNull
    private ProgressIndicator indicator() {
        if (this.myIndicator == null) {
            this.myIndicator = this.myProgressTask.getIndicator();
            if (this.myIndicator == null) {
                this.myIndicator = new EmptyProgressIndicator();
            }
        }
        ProgressIndicator progressIndicator = this.myIndicator;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessingTask", "indicator"));
        }
        return progressIndicator;
    }

    public void prepare() {
        ArrayList steps = ContainerUtil.newArrayListWithCapacity((int)((int)((double)this.myUsages.length * 1.2)));
        HashMap deleteSteps = ContainerUtil.newHashMap();
        for (UsageInfo usageInfo : this.myUsages) {
            if (!(usageInfo instanceof InterTypeUsageInfo)) {
                LOG.error("Unknown usage type: " + usageInfo);
                continue;
            }
            InterTypeUsageInfo usage = (InterTypeUsageInfo)usageInfo;
            PsiAspect source = usage.getSource();
            if (source == null) {
                LOG.error("Source aspect lost: " + (Object)((Object)usage));
                continue;
            }
            PsiClass target = usage.getTarget();
            if (target == null) {
                LOG.error("Target class lost: " + (Object)((Object)usage));
                continue;
            }
            PsiElement element = usage.getElement();
            if (element instanceof PsiInterTypeDeclaration && element instanceof PsiMember) {
                steps.add(new MemberStep(source, target, (PsiMember)element));
            } else if (element instanceof PsiInterTypeTypeAnnotation) {
                steps.add(new TypeAnnoStep(source, target, (PsiInterTypeTypeAnnotation)element));
            } else {
                LOG.error("Unknown element: " + element);
            }
            if (!this.myDeleteAspects || deleteSteps.containsKey(source)) continue;
            deleteSteps.put(source, new DeleteSourceStep(source));
        }
        steps.addAll(deleteSteps.values());
        this.mySteps = steps;
        ProgressIndicator indicator = this.indicator();
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        indicator.setText(AspectJBundle.message("action.push.in.progress", new Object[0]));
    }

    public boolean isDone() {
        return this.mySteps == null || this.myCount >= this.mySteps.size();
    }

    public boolean iteration() {
        assert (!this.isDone());
        Step step = this.mySteps.get(this.myCount);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Step " + (this.myCount + 1) + " of " + this.mySteps.size() + ": " + step);
        }
        step.process();
        this.indicator().setFraction((double)(++this.myCount) / (double)this.mySteps.size());
        if (this.isDone()) {
            this.cleanup();
        }
        return this.isDone();
    }

    private void cleanup() {
        if (this.mySteps == null) {
            return;
        }
        for (Step aStep : this.mySteps) {
            aStep.cleanup();
        }
        this.mySteps.clear();
    }

    public void stop() {
    }

    private static class DeleteSourceStep
    extends Step {
        protected DeleteSourceStep(PsiAspect source) {
            super(source);
        }

        @Override
        public void process() {
            if (DeleteSourceStep.canDelete(this.source)) {
                WriteAction.run(() -> this.source.delete());
            }
        }

        private static boolean canDelete(PsiAspect aspect) {
            return PsiTreeUtil.skipSiblingsForward((PsiElement)aspect.getLBrace(), (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class}) == aspect.getRBrace();
        }

        @Override
        public void cleanup() {
        }

        public String toString() {
            return "DeleteSourceStep[" + this.source.getQualifiedName() + "]";
        }
    }

    private static class TypeAnnoStep
    extends ClassTargetStep {
        public final PsiInterTypeTypeAnnotation typeAnnotation;

        public TypeAnnoStep(PsiAspect source, PsiClass target, PsiInterTypeTypeAnnotation typeAnnotation) {
            super(source, target);
            this.typeAnnotation = typeAnnotation;
        }

        @Override
        public void process() {
            PsiModifierList modifierList = this.target.getModifierList();
            if (modifierList == null) {
                LOG.error("Missing modifier list: " + this.target);
                return;
            }
            PsiAnnotation annotation = this.typeAnnotation.getAnnotation();
            ChangeContextUtil.encodeContextInfo((PsiElement)annotation, (boolean)true, (boolean)false);
            WriteAction.run(() -> {
                PsiElement newElement = modifierList.addBefore(annotation.copy(), modifierList.getFirstChild());
                this.typeAnnotation.delete();
                ChangeContextUtil.decodeContextInfo((PsiElement)newElement, null, null);
            });
        }

        @Override
        public void cleanup() {
        }

        public String toString() {
            return "TypeAnnoStep[" + this.target.getQualifiedName() + " @ " + TypeAnnoStep.getAnnotationName(this.typeAnnotation.getAnnotation()) + "]";
        }

        @NotNull
        private static String getAnnotationName(PsiAnnotation annotation) {
            String qName = annotation.getQualifiedName();
            String string = qName != null ? qName : annotation.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessingTask$TypeAnnoStep", "getAnnotationName"));
            }
            return string;
        }
    }

    private static class MemberStep
    extends ClassTargetStep {
        private static final Map<PsiAspect, Map<PsiClass, Collection<PsiMember>>> GROUPS = ContainerUtil.newHashMap();
        public final PsiMember member;
        public final Collection<PsiMember> members;

        public MemberStep(PsiAspect source, PsiClass target, PsiMember member) {
            super(source, target);
            this.member = member;
            this.members = MemberStep.getGroup(source, target);
            this.members.add(this.member);
        }

        private static Collection<PsiMember> getGroup(PsiAspect source, PsiClass target) {
            ArrayList members;
            HashMap sourceMap = GROUPS.get(source);
            if (sourceMap == null) {
                sourceMap = ContainerUtil.newHashMap();
                GROUPS.put(source, sourceMap);
            }
            if ((members = sourceMap.get(target)) == null) {
                members = ContainerUtil.newArrayList();
                sourceMap.put(target, members);
            }
            return members;
        }

        private static void deleteGroup(PsiAspect source, PsiClass target) {
            Map<PsiClass, Collection<PsiMember>> sourceMap = GROUPS.get(source);
            if (sourceMap != null) {
                sourceMap.remove(target);
                if (sourceMap.isEmpty()) {
                    GROUPS.remove(source);
                }
            }
        }

        @Override
        public void process() {
            MoveMemberHandler handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(this.target.getLanguage());
            if (handler == null) {
                LOG.error("No move handler for target: " + this.target);
                return;
            }
            final PsiMember[] memberArray = this.members.toArray(new PsiMember[this.members.size()]);
            MoveMembersOptions options = new MoveMembersOptions(){

                public PsiMember[] getSelectedMembers() {
                    return memberArray;
                }

                public String getTargetClassName() {
                    return target.getName();
                }

                public String getMemberVisibility() {
                    return "";
                }

                public boolean makeEnumConstant() {
                    return false;
                }
            };
            ChangeContextUtil.encodeContextInfo((PsiElement)this.member, (boolean)true, (boolean)false);
            PsiElement anchor = handler.getAnchor(this.member, this.target, (Set)new HashSet());
            WriteAction.run(() -> {
                PsiMember newElement = handler.doMove(options, this.member, anchor, this.target);
                ChangeContextUtil.decodeContextInfo((PsiElement)newElement, null, null);
            });
        }

        @Override
        public void cleanup() {
            MemberStep.deleteGroup(this.source, this.target);
        }

        public String toString() {
            return "MemberStep[" + this.target.getQualifiedName() + " . " + this.member.getName() + "]";
        }
    }

    private static abstract class ClassTargetStep
    extends Step {
        public final PsiClass target;

        private ClassTargetStep(PsiAspect source, PsiClass target) {
            super(source);
            this.target = target;
        }
    }

    private static abstract class Step {
        public final PsiAspect source;

        protected Step(PsiAspect source) {
            this.source = source;
        }

        public abstract void process();

        public abstract void cleanup();
    }
}

