/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopiesHolder;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnCompatibilityChecker;
import org.jetbrains.idea.svn.SvnCopyRootSimple;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnMapping;
import org.jetbrains.idea.svn.SvnMappingSavedPart;
import org.jetbrains.idea.svn.SvnRootsDetector;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.UniqueRootsFilter;
import org.jetbrains.idea.svn.info.Info;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

@State(name="SvnFileUrlMappingImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SvnFileUrlMappingImpl
implements SvnFileUrlMapping,
PersistentStateComponent<SvnMappingSavedPart> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnFileUrlMappingImpl");
    private final SvnCompatibilityChecker myChecker;
    private final Object myMonitor;
    private final SvnMapping myMapping;
    private final SvnMapping myMoreRealMapping;
    private final List<RootUrlInfo> myErrorRoots;
    @NotNull
    private final MyRootsHelper myRootsHelper;
    private final Project myProject;
    private final NestedCopiesHolder myNestedCopiesHolder;
    private boolean myInitialized;
    private boolean myInitedReloaded;

    @NotNull
    public static SvnFileUrlMappingImpl getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl", "getInstance"));
        }
        SvnFileUrlMappingImpl svnFileUrlMappingImpl = (SvnFileUrlMappingImpl)ServiceManager.getService((Project)project, SvnFileUrlMapping.class);
        if (svnFileUrlMappingImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl", "getInstance"));
        }
        return svnFileUrlMappingImpl;
    }

    private SvnFileUrlMappingImpl(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl", "<init>"));
        }
        if (vcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsManager", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl", "<init>"));
        }
        this.myMonitor = new Object();
        this.myProject = project;
        this.myMapping = new SvnMapping();
        this.myMoreRealMapping = new SvnMapping();
        this.myErrorRoots = ContainerUtil.newArrayList();
        this.myRootsHelper = new MyRootsHelper(project, vcsManager);
        this.myChecker = new SvnCompatibilityChecker(project);
        this.myNestedCopiesHolder = new NestedCopiesHolder();
    }

    @Override
    @Nullable
    public SVNURL getUrlForFile(File file) {
        RootUrlInfo rootUrlInfo = this.getWcRootForFilePath(file);
        if (rootUrlInfo == null) {
            return null;
        }
        String absolutePath = file.getAbsolutePath();
        String rootAbsPath = rootUrlInfo.getIoFile().getAbsolutePath();
        if (absolutePath.length() < rootAbsPath.length()) {
            if (absolutePath.equals(rootAbsPath.substring(0, rootAbsPath.length() - 1))) {
                return rootUrlInfo.getAbsoluteUrlAsUrl();
            }
            return null;
        }
        String relativePath = absolutePath.substring(rootAbsPath.length());
        try {
            return rootUrlInfo.getAbsoluteUrlAsUrl().appendPath(FileUtil.toSystemIndependentName((String)relativePath), true);
        }
        catch (SVNException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public File getLocalPath(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl", "getLocalPath"));
        }
        Object object = this.myMonitor;
        synchronized (object) {
            String rootUrl = this.getUrlRootForUrl(url);
            if (rootUrl == null) {
                return null;
            }
            RootUrlInfo parentInfo = this.myMoreRealMapping.byUrl(rootUrl);
            if (parentInfo == null) {
                return null;
            }
            return new File(parentInfo.getIoFile(), url.substring(rootUrl.length()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RootUrlInfo getWcRootForFilePath(File file) {
        Object object = this.myMonitor;
        synchronized (object) {
            String root = this.getRootForPath(file);
            if (root == null) {
                return null;
            }
            return this.myMoreRealMapping.byFile(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RootUrlInfo getWcRootForUrl(String url) {
        Object object = this.myMonitor;
        synchronized (object) {
            String rootUrl = this.getUrlRootForUrl(url);
            if (rootUrl == null) {
                return null;
            }
            RootUrlInfo result = this.myMoreRealMapping.byUrl(rootUrl);
            if (result == null) {
                LOG.info("Inconsistent maps for url:" + url + " found root url: " + rootUrl);
                return null;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RootUrlInfo> getAllWcInfos() {
        Object object = this.myMonitor;
        synchronized (object) {
            return this.myMoreRealMapping.getAllCopies();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RootUrlInfo> getErrorRoots() {
        Object object = this.myMonitor;
        synchronized (object) {
            return ContainerUtil.newArrayList(this.myErrorRoots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> convertRoots(@NotNull List<VirtualFile> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl", "convertRoots"));
        }
        if (MyRootsHelper.isInProgress()) {
            ArrayList arrayList = ContainerUtil.newArrayList(result);
            if (arrayList != null) return arrayList;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl", "convertRoots"));
        }
        Object object = this.myMonitor;
        // MONITORENTER : object
        List<VirtualFile> cachedRoots = this.myMoreRealMapping.getUnderVcsRoots();
        List<VirtualFile> lonelyRoots = this.myMoreRealMapping.getLonelyRoots();
        if (!lonelyRoots.isEmpty()) {
            this.myChecker.reportNoRoots(lonelyRoots);
        }
        ArrayList arrayList = ContainerUtil.newArrayList(cachedRoots.isEmpty() ? result : cachedRoots);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl", "convertRoots"));
    }

    public void acceptNestedData(Set<NestedCopyInfo> set) {
        this.myNestedCopiesHolder.add(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean init() {
        Object object = this.myMonitor;
        synchronized (object) {
            boolean result = this.myInitialized;
            this.myInitialized = true;
            return result;
        }
    }

    public void realRefresh(Runnable afterRefreshCallback) {
        if (this.myProject.isDisposed()) {
            afterRefreshCallback.run();
        } else {
            SvnVcs vcs = SvnVcs.getInstance(this.myProject);
            VirtualFile[] roots = this.myRootsHelper.execute();
            SvnRootsDetector rootsDetector = new SvnRootsDetector(vcs, this, this.myNestedCopiesHolder);
            rootsDetector.detectCopyRoots(roots, this.init(), afterRefreshCallback);
        }
    }

    public void applyDetectionResult(@NotNull SvnRootsDetector.Result result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl", "applyDetectionResult"));
        }
        new NewRootsApplier(result).apply();
    }

    @Nullable
    public String getUrlRootForUrl(String currentUrl) {
        for (String url : this.myMoreRealMapping.getUrls()) {
            if (!SVNPathUtil.isAncestor((String)url, (String)currentUrl)) continue;
            return url;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getRootForPath(File currentPath) {
        String convertedPath = currentPath.getAbsolutePath();
        convertedPath = currentPath.isDirectory() && !convertedPath.endsWith(File.separator) ? convertedPath + File.separator : convertedPath;
        Object object = this.myMonitor;
        synchronized (object) {
            return this.myMoreRealMapping.getRootForPath(convertedPath);
        }
    }

    @Override
    @NotNull
    public VirtualFile[] getNotFilteredRoots() {
        VirtualFile[] virtualFileArray = this.myRootsHelper.execute();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl", "getNotFilteredRoots"));
        }
        return virtualFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.myMonitor;
        synchronized (object) {
            return this.myMapping.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnMappingSavedPart getState() {
        SvnMappingSavedPart result = new SvnMappingSavedPart();
        SvnMapping mapping = new SvnMapping();
        SvnMapping realMapping = new SvnMapping();
        Iterator<RootUrlInfo> iterator = this.myMonitor;
        synchronized (iterator) {
            mapping.copyFrom(this.myMapping);
            realMapping.copyFrom(this.myMoreRealMapping);
        }
        for (RootUrlInfo info : mapping.getAllCopies()) {
            result.add(SvnFileUrlMappingImpl.convert(info));
        }
        for (RootUrlInfo info : realMapping.getAllCopies()) {
            result.addReal(SvnFileUrlMappingImpl.convert(info));
        }
        return result;
    }

    private static SvnCopyRootSimple convert(RootUrlInfo info) {
        SvnCopyRootSimple copy = new SvnCopyRootSimple();
        copy.myVcsRoot = FileUtil.toSystemDependentName((String)info.getRoot().getPath());
        copy.myCopyRoot = info.getIoFile().getAbsolutePath();
        return copy;
    }

    public void loadState(SvnMappingSavedPart state) {
        ((ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)this.myProject)).addInitializationRequest(VcsInitObject.AFTER_COMMON, (Runnable)((DumbAwareRunnable)() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            SvnMapping mapping = new SvnMapping();
            SvnMapping realMapping = new SvnMapping();
            try {
                this.fillMapping(mapping, state.getMappingRoots());
                this.fillMapping(realMapping, state.getMoreRealMappingRoots());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                LOG.info(t);
                return;
            }
            Object object = this.myMonitor;
            synchronized (object) {
                this.myMapping.copyFrom(mapping);
                this.myMoreRealMapping.copyFrom(realMapping);
            }
        })));
    }

    private void fillMapping(SvnMapping mapping, List<SvnCopyRootSimple> list) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (SvnCopyRootSimple simple : list) {
            SvnVcs vcs;
            Info svnInfo;
            VirtualFile copyRoot = lfs.findFileByIoFile(new File(simple.myCopyRoot));
            VirtualFile vcsRoot = lfs.findFileByIoFile(new File(simple.myVcsRoot));
            if (copyRoot == null || vcsRoot == null || (svnInfo = (vcs = SvnVcs.getInstance(this.myProject)).getInfo(copyRoot)) == null || svnInfo.getRepositoryRootURL() == null) continue;
            Node node = new Node(copyRoot, svnInfo.getURL(), svnInfo.getRepositoryRootURL());
            RootUrlInfo info = new RootUrlInfo(node, SvnFormatSelector.findRootAndGetFormat(svnInfo.getFile()), vcsRoot);
            mapping.add(info);
        }
    }

    private class NewRootsApplier {
        @NotNull
        private final SvnRootsDetector.Result myResult;
        @NotNull
        private final SvnMapping myNewMapping;
        @NotNull
        private final SvnMapping myNewFilteredMapping;

        private NewRootsApplier(SvnRootsDetector.Result result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl$NewRootsApplier", "<init>"));
            }
            this.myResult = result;
            this.myNewMapping = new SvnMapping();
            this.myNewFilteredMapping = new SvnMapping();
        }

        public void apply() {
            this.myNewMapping.addAll(this.myResult.getTopRoots());
            this.myNewMapping.reportLonelyRoots(this.myResult.getLonelyRoots());
            this.myNewFilteredMapping.addAll(new UniqueRootsFilter().filter(this.myResult.getTopRoots()));
            this.runUpdateMappings();
        }

        private void runUpdateMappings() {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (SvnFileUrlMappingImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean mappingsChanged = this.updateMappings();
                this.notifyRootsReloaded(mappingsChanged);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateMappings() {
            boolean mappingsChanged;
            Object object = SvnFileUrlMappingImpl.this.myMonitor;
            synchronized (object) {
                mappingsChanged = !SvnFileUrlMappingImpl.this.myMoreRealMapping.equals(this.myNewFilteredMapping);
                mappingsChanged |= !SvnFileUrlMappingImpl.this.myErrorRoots.equals(this.myResult.getErrorRoots());
                SvnFileUrlMappingImpl.this.myMapping.copyFrom(this.myNewMapping);
                SvnFileUrlMappingImpl.this.myMoreRealMapping.copyFrom(this.myNewFilteredMapping);
                SvnFileUrlMappingImpl.this.myErrorRoots.clear();
                SvnFileUrlMappingImpl.this.myErrorRoots.addAll(this.myResult.getErrorRoots());
            }
            return mappingsChanged;
        }

        private void notifyRootsReloaded(boolean mappingsChanged) {
            MessageBus bus = SvnFileUrlMappingImpl.this.myProject.getMessageBus();
            if (mappingsChanged || !SvnFileUrlMappingImpl.this.myInitedReloaded) {
                SvnFileUrlMappingImpl.this.myInitedReloaded = true;
                ((Consumer)bus.syncPublisher(SvnVcs.ROOTS_RELOADED)).consume((Object)true);
                ((VcsListener)bus.syncPublisher(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN)).directoryMappingChanged();
            } else {
                ((Consumer)bus.syncPublisher(SvnVcs.ROOTS_RELOADED)).consume((Object)false);
            }
        }
    }

    private static class MyRootsHelper {
        @NotNull
        private static final ThreadLocal<Boolean> ourInProgress = ThreadLocal.withInitial(() -> Boolean.FALSE);
        @NotNull
        private final Project myProject;
        @NotNull
        private final ProjectLevelVcsManager myVcsManager;

        private MyRootsHelper(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl$MyRootsHelper", "<init>"));
            }
            if (vcsManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsManager", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl$MyRootsHelper", "<init>"));
            }
            this.myProject = project;
            this.myVcsManager = vcsManager;
        }

        @NotNull
        public VirtualFile[] execute() {
            VirtualFile[] virtualFileArray;
            block3: {
                ourInProgress.set(Boolean.TRUE);
                virtualFileArray = this.myVcsManager.getRootsUnderVcs((AbstractVcs)SvnVcs.getInstance(this.myProject));
                if (virtualFileArray != null) break block3;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl$MyRootsHelper", "execute"));
            }
            return virtualFileArray;
            finally {
                ourInProgress.set(Boolean.FALSE);
            }
        }

        public static boolean isInProgress() {
            return ourInProgress.get();
        }
    }
}

