/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class BranchesLoader
implements Runnable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final NewRootBunch myBunch;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final String myUrl;
    @NotNull
    private final InfoReliability myInfoReliability;
    private final boolean myPassive;

    public BranchesLoader(@NotNull Project project, @NotNull NewRootBunch bunch, @NotNull String url, @NotNull InfoReliability infoReliability, @NotNull VirtualFile root, boolean passive) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/branchConfig/BranchesLoader", "<init>"));
        }
        if (bunch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bunch", "org/jetbrains/idea/svn/branchConfig/BranchesLoader", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/branchConfig/BranchesLoader", "<init>"));
        }
        if (infoReliability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infoReliability", "org/jetbrains/idea/svn/branchConfig/BranchesLoader", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/branchConfig/BranchesLoader", "<init>"));
        }
        this.myProject = project;
        this.myBunch = bunch;
        this.myUrl = url;
        this.myInfoReliability = infoReliability;
        this.myRoot = root;
        this.myPassive = passive;
    }

    @Override
    public void run() {
        try {
            List<SvnBranchItem> branches = this.loadBranches();
            this.myBunch.updateBranches(this.myRoot, this.myUrl, new InfoStorage<List<SvnBranchItem>>(branches, this.myInfoReliability));
        }
        catch (VcsException | SVNException e) {
            this.showError((Exception)e);
        }
    }

    @NotNull
    public List<SvnBranchItem> loadBranches() throws SVNException, VcsException {
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        SVNURL branchesUrl = SVNURL.parseURIEncoded((String)this.myUrl);
        LinkedList<SvnBranchItem> result = new LinkedList<SvnBranchItem>();
        SvnTarget target = SvnTarget.fromURL((SVNURL)branchesUrl);
        DirectoryEntryConsumer handler = BranchesLoader.createConsumer(result);
        vcs.getFactory(target).create(BrowseClient.class, !this.myPassive).list(target, SVNRevision.HEAD, Depth.IMMEDIATES, handler);
        Collections.sort(result);
        LinkedList<SvnBranchItem> linkedList = result;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/BranchesLoader", "loadBranches"));
        }
        return linkedList;
    }

    private void showError(Exception e) {
        if (InfoReliability.setByUser.equals((Object)this.myInfoReliability)) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)("Branches load error: " + e.getMessage()), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
        }
    }

    @NotNull
    private static DirectoryEntryConsumer createConsumer(@NotNull List<SvnBranchItem> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/svn/branchConfig/BranchesLoader", "createConsumer"));
        }
        DirectoryEntryConsumer directoryEntryConsumer = entry -> {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/svn/branchConfig/BranchesLoader", "lambda$createConsumer$0"));
            }
            if (entry.getDate() != null) {
                result.add(new SvnBranchItem(entry.getUrl().toDecodedString(), entry.getDate(), entry.getRevision()));
            }
        };
        if (directoryEntryConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/BranchesLoader", "createConsumer"));
        }
        return directoryEntryConsumer;
    }
}

