/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.svnkit.lowLevel;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import org.jetbrains.idea.svn.svnkit.SvnKitProgressCanceller;
import org.jetbrains.idea.svn.svnkit.lowLevel.ApplicationLevelNumberConnectionsGuardImpl;
import org.jetbrains.idea.svn.svnkit.lowLevel.CachingSvnRepositoryPool;
import org.jetbrains.idea.svn.svnkit.lowLevel.NoKeepConnectionPool;
import org.jetbrains.idea.svn.svnkit.lowLevel.ProxySvnLog;
import org.jetbrains.idea.svn.svnkit.lowLevel.QuicklyDisposableISVNAuthenticationManager;
import org.jetbrains.idea.svn.svnkit.lowLevel.QuicklyDisposableISVNCanceller;
import org.jetbrains.idea.svn.svnkit.lowLevel.QuicklyDisposableISVNConnectionListener;
import org.jetbrains.idea.svn.svnkit.lowLevel.QuicklyDisposableISVNTunnelProvider;
import org.jetbrains.idea.svn.svnkit.lowLevel.SvnRepositoryPool;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.ISVNConnectionListener;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SvnIdeaRepositoryPoolManager
implements ISVNRepositoryPool,
ISVNSession {
    private static final ApplicationLevelNumberConnectionsGuardImpl ourGuard = new ApplicationLevelNumberConnectionsGuardImpl();
    private final ISVNDebugLog myLog;
    private final QuicklyDisposableISVNCanceller myCanceller;
    private final SvnRepositoryPool myPool;
    private volatile boolean myKeepConnection;
    private final QuicklyDisposableISVNTunnelProvider myTunnelProvider;
    private final QuicklyDisposableISVNConnectionListener myListener;
    private QuicklyDisposableISVNAuthenticationManager myAuthManager;
    private ThrowableConvertor<SVNURL, SVNRepository, SVNException> myCreator;

    public SvnIdeaRepositoryPoolManager(boolean keepConnection, ISVNAuthenticationManager authManager, ISVNTunnelProvider tunnelProvider) {
        this(keepConnection, authManager, tunnelProvider, -1, -1);
    }

    public SvnIdeaRepositoryPoolManager(boolean keepConnection, ISVNAuthenticationManager authManager, ISVNTunnelProvider tunnelProvider, int maxCached, int maxConcurrent) {
        this.myKeepConnection = keepConnection;
        this.myTunnelProvider = new QuicklyDisposableISVNTunnelProvider(tunnelProvider);
        this.myAuthManager = new QuicklyDisposableISVNAuthenticationManager(authManager);
        this.myLog = new ProxySvnLog(SVNDebugLog.getDefaultLog());
        this.myCanceller = new QuicklyDisposableISVNCanceller(new SvnKitProgressCanceller());
        ThrowableConvertor<SVNURL, SVNRepository, SVNException> creator = new ThrowableConvertor<SVNURL, SVNRepository, SVNException>(){

            public SVNRepository convert(SVNURL svnurl) throws SVNException {
                SVNRepository repos = SvnIdeaRepositoryPoolManager.this.myCreator != null ? (SVNRepository)SvnIdeaRepositoryPoolManager.this.myCreator.convert((Object)svnurl) : SVNRepositoryFactory.create((SVNURL)svnurl, (ISVNSession)SvnIdeaRepositoryPoolManager.this);
                repos.setAuthenticationManager((ISVNAuthenticationManager)SvnIdeaRepositoryPoolManager.this.myAuthManager);
                repos.setTunnelProvider((ISVNTunnelProvider)SvnIdeaRepositoryPoolManager.this.myTunnelProvider);
                repos.setDebugLog(SvnIdeaRepositoryPoolManager.this.myLog);
                repos.setCanceller((ISVNCanceller)SvnIdeaRepositoryPoolManager.this.myCanceller);
                if (SvnIdeaRepositoryPoolManager.this.myKeepConnection) {
                    repos.addConnectionListener((ISVNConnectionListener)SvnIdeaRepositoryPoolManager.this.myListener);
                }
                return repos;
            }
        };
        ThrowableConsumer<Pair<SVNURL, SVNRepository>, SVNException> adjuster = new ThrowableConsumer<Pair<SVNURL, SVNRepository>, SVNException>(){

            public void consume(Pair<SVNURL, SVNRepository> pair) throws SVNException {
                SVNRepository repository = (SVNRepository)pair.getSecond();
                SVNURL url = (SVNURL)pair.getFirst();
                repository.setLocation(url, false);
                repository.addConnectionListener((ISVNConnectionListener)SvnIdeaRepositoryPoolManager.this.myListener);
                repository.setAuthenticationManager((ISVNAuthenticationManager)SvnIdeaRepositoryPoolManager.this.myAuthManager);
                repository.setTunnelProvider((ISVNTunnelProvider)SvnIdeaRepositoryPoolManager.this.myTunnelProvider);
                repository.setDebugLog(SvnIdeaRepositoryPoolManager.this.myLog);
                repository.setCanceller((ISVNCanceller)SvnIdeaRepositoryPoolManager.this.myCanceller);
            }
        };
        if (keepConnection) {
            CachingSvnRepositoryPool pool = new CachingSvnRepositoryPool(creator, maxCached, maxConcurrent, adjuster, ourGuard);
            this.myPool = pool;
            ISVNConnectionListener listener = new ISVNConnectionListener(){

                public void connectionOpened(SVNRepository repository) {
                    ourGuard.connectionOpened();
                }

                public void connectionClosed(SVNRepository repository) {
                    repository.removeConnectionListener((ISVNConnectionListener)SvnIdeaRepositoryPoolManager.this.myListener);
                    SvnIdeaRepositoryPoolManager.this.myPool.returnRepo(repository);
                    ourGuard.connectionClosed();
                }
            };
            this.myListener = new QuicklyDisposableISVNConnectionListener(listener);
            ourGuard.addRepositoryPool(pool);
        } else {
            this.myListener = null;
            this.myPool = new NoKeepConnectionPool(creator);
        }
    }

    public void setAuthenticationManager(ISVNAuthenticationManager authManager) {
        this.myAuthManager = new QuicklyDisposableISVNAuthenticationManager(authManager);
    }

    public void setCanceller(ISVNCanceller canceller) {
        throw new UnsupportedOperationException();
    }

    public void setDebugLog(ISVNDebugLog log) {
        throw new UnsupportedOperationException();
    }

    public SVNRepository createRepository(SVNURL url, boolean mayReuse) throws SVNException {
        return this.myPool.getRepo(url, mayReuse);
    }

    public void shutdownConnections(boolean shutdownAll) {
        this.dispose();
    }

    public void dispose() {
        if (this.myKeepConnection) {
            ourGuard.removeRepositoryPool((CachingSvnRepositoryPool)this.myPool);
        }
        this.myKeepConnection = false;
        if (this.myListener != null) {
            this.myListener.dispose();
        }
        this.myAuthManager.dispose();
        this.myTunnelProvider.dispose();
        this.myPool.dispose();
    }

    public boolean keepConnection(SVNRepository repository) {
        return this.myKeepConnection;
    }

    public void saveCommitMessage(SVNRepository repository, long revision, String message) {
    }

    public String getCommitMessage(SVNRepository repository, long revision) {
        return null;
    }

    public boolean hasCommitMessage(SVNRepository repository, long revision) {
        return false;
    }

    public void setCreator(ThrowableConvertor<SVNURL, SVNRepository, SVNException> creator) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myCreator = creator;
    }

    public SvnRepositoryPool getPool() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return this.myPool;
    }

    public static ApplicationLevelNumberConnectionsGuardImpl getOurGuard() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return ourGuard;
    }
}

