/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.AdjustComponentWhenShown;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.update.SvnPanel;

public class MultipleRootEditorWithSplitter
extends JPanel {
    private JList myList;
    private JPanel myConfigureRootPanel;
    @NonNls
    private static final String EMPTY = "empty";

    public MultipleRootEditorWithSplitter(Map<FilePath, SvnPanel> rootToPanel, final Project project) {
        super(new BorderLayout());
        final Splitter splitter = new Splitter(false, 0.5f);
        splitter.setHonorComponentsMinimumSize(false);
        this.add((Component)splitter, "Center");
        this.myList = new JBList();
        Color borderColor = UIUtil.getBorderColor();
        this.myConfigureRootPanel = new JPanel();
        this.myConfigureRootPanel.setBorder(BorderFactory.createLineBorder(borderColor));
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myList));
        splitter.setSecondComponent((JComponent)this.myConfigureRootPanel);
        CardLayout layout = new CardLayout();
        this.myConfigureRootPanel.setLayout(layout);
        DefaultListModel<FilePath> listModel = new DefaultListModel<FilePath>();
        layout.addLayoutComponent(new JPanel(), EMPTY);
        int minimumRightSize = 320;
        for (FilePath root : rootToPanel.keySet()) {
            JPanel panel = rootToPanel.get(root).getPanel();
            this.myConfigureRootPanel.add((Component)panel, root.getPath());
            if (panel.getMinimumSize().width > 0) {
                minimumRightSize = Math.max(minimumRightSize, panel.getPreferredSize().width);
            }
            listModel.addElement(root);
        }
        this.myConfigureRootPanel.revalidate();
        this.myList.setModel(listModel);
        this.myList.getSelectionModel().setSelectionMode(0);
        this.myList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/update/MultipleRootEditorWithSplitter$1", "customizeCellRenderer"));
                }
                if (value instanceof FilePath) {
                    FilePath path = (FilePath)value;
                    if (path.getVirtualFile() != null) {
                        this.append(VcsPathPresenter.getInstance((Project)project).getPresentableRelativePathFor(path.getVirtualFile()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else {
                        this.append(VcsPathPresenter.getInstance((Project)project).getPresentableRelativePathFor(path.getVirtualFileParent()) + File.separator + path.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            }
        });
        this.myList.addListSelectionListener(e -> {
            FilePath root = (FilePath)this.myList.getSelectedValue();
            if (root != null) {
                layout.show(this.myConfigureRootPanel, root.getPath());
            } else {
                layout.show(this.myConfigureRootPanel, EMPTY);
            }
        });
        this.myList.setSelectedIndex(0);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myList, true));
        final int finalMinimumRightSize = minimumRightSize;
        new AdjustComponentWhenShown(){

            protected boolean init() {
                if (MultipleRootEditorWithSplitter.this.getWidth() < finalMinimumRightSize * 2) {
                    int left = MultipleRootEditorWithSplitter.this.getWidth() - finalMinimumRightSize;
                    float newProportion = left < 0 ? 0.2f : (float)left / (float)MultipleRootEditorWithSplitter.this.getWidth();
                    splitter.setProportion(newProportion);
                }
                return true;
            }

            protected boolean canExecute() {
                return MultipleRootEditorWithSplitter.this.getWidth() > 0;
            }
        }.install((Component)splitter);
    }
}

