/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.appServerIntegrations;

import com.intellij.j2ee.appServerIntegrations.AppServerDKsEditor;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationServersConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private AppServerDKsEditor myAppServerDKsEditor;
    private AppServerIntegration[] myIntegrations;
    private final ApplicationServer mySelected;

    private ApplicationServersConfigurable(@Nullable ApplicationServer selected, @NotNull AppServerIntegration integration) {
        if (integration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "integration", "com/intellij/j2ee/appServerIntegrations/ApplicationServersConfigurable", "<init>"));
        }
        this.myIntegrations = new AppServerIntegration[]{integration};
        this.mySelected = selected;
    }

    public ApplicationServersConfigurable() {
        this.mySelected = null;
    }

    public String getDisplayName() {
        return J2EEBundle.message((String)"application.servers.configurable.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "preferences.applicationServers";
    }

    public JComponent createComponent() {
        if (this.myIntegrations == null) {
            this.myIntegrations = AppServerIntegrationsManager.getInstance().getAllIntegrations();
        }
        this.myAppServerDKsEditor = new AppServerDKsEditor(this.myIntegrations, this.mySelected);
        return this.myAppServerDKsEditor.getComponent();
    }

    public boolean isModified() {
        return this.myAppServerDKsEditor.isModified();
    }

    public void disposeUIResources() {
        if (this.myAppServerDKsEditor != null) {
            this.myAppServerDKsEditor.disposeUIResources();
        }
    }

    public void apply() throws ConfigurationException {
        this.myAppServerDKsEditor.apply();
    }

    public void reset() {
        this.myAppServerDKsEditor.reset();
    }

    @NonNls
    public String getDimensionServiceKey() {
        return "#com.intellij.j2ee.appServerIntegrations.ApplicationServersConfigurable";
    }

    public ApplicationServer getSelectedApplicationServer() {
        if (this.myAppServerDKsEditor == null) {
            return null;
        }
        return this.myAppServerDKsEditor.getSelectedAppliactionServer();
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/appServerIntegrations/ApplicationServersConfigurable", "getId"));
        }
        return string;
    }

    public static ApplicationServersConfigurable createConfigurable(@NotNull AppServerIntegration integration, @Nullable ApplicationServer selected) {
        if (integration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "integration", "com/intellij/j2ee/appServerIntegrations/ApplicationServersConfigurable", "createConfigurable"));
        }
        return new ApplicationServersConfigurable(selected, integration);
    }
}

